(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Scope.i3                                              *)
(* Last modified on Tue Jun 30 14:10:57 PDT 1992 by kalsow     *)
(*      modified on Thu Aug  9 20:08:18 1990 by muller         *)

INTERFACE Scope;

IMPORT M3, String, Value;

TYPE
  T = M3.Scope;

  ValueList = UNTRACED REF ARRAY OF Value.T;
  NameList  = UNTRACED REF ARRAY OF String.T;

  Visitor = PROCEDURE (node: Value.T);

VAR
  Initial: T;

PROCEDURE PushNew (open: BOOLEAN;  name: String.T;
                    viaFrame := FALSE;  module := FALSE): T;
PROCEDURE PopNew ();

PROCEDURE New1 (obj: Value.T): T;

PROCEDURE Push (t: T): T;
PROCEDURE Pop  (old: T);
PROCEDURE Top  (): T;
PROCEDURE OuterMost  (t: T): BOOLEAN;

PROCEDURE Insert (o: Value.T);
PROCEDURE InsertUnderAlias (o: Value.T;  alias: String.T);

PROCEDURE LookUp    (t: T;  name: String.T;  strict: BOOLEAN): Value.T;
PROCEDURE LookUpX   (t: T;  name: String.T): Value.T;
PROCEDURE LookUpQID (t: T;  READONLY q: String.QID): Value.T;

PROCEDURE IsLexicallyNested (t: T;  lexical: BOOLEAN);
PROCEDURE EmitFrameName (t: T; testOnly := FALSE): BOOLEAN;
PROCEDURE EmitLocalFrameName (t: T): BOOLEAN;
PROCEDURE EmitFrameType (t: T);
PROCEDURE GenFrameTypes ();

PROCEDURE ToList (t: T;  VAR objs: ValueList;  VAR cnt: INTEGER);
PROCEDURE ToListWithAliases (t: T;  VAR objs: ValueList;  VAR cnt: INTEGER;
                               VAR aliases: NameList);

PROCEDURE TypeCheck (t: T;  VAR cs: Value.CheckState);

PROCEDURE Enter (t: T);
PROCEDURE InitValues (t: T);
PROCEDURE Exit (t: T);

PROCEDURE WarnUnused (t: T);

PROCEDURE GlobalName   (v: Value.T;  VAR p: String.Stack);
PROCEDURE NameToPrefix (v: Value.T;  VAR p: String.Stack;
                        considerExternal := TRUE;
                        dots := FALSE);

PROCEDURE GenName (v: Value.T;  dots := FALSE);

PROCEDURE Initialize ();
PROCEDURE Reset ();

END Scope.
