(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Frame.i3                                              *)
(* Last Modified On Tue Feb 25 08:59:00 PST 1992 by kalsow     *)

INTERFACE Frame;

IMPORT Type;

TYPE
  T = RECORD
    size : INTEGER;  (* current size of the frame in address sized chunks *)
    max  : INTEGER;  (* maximum value that size ever attained *)
    gone : INTEGER;  (* the size of the "popped" frame chunks *)
  END;

VAR cur: T;

PROCEDURE Push (VAR t: T;  locals: INTEGER;  formatted_code := FALSE);
PROCEDURE Pop  (READONLY t: T);
(* starts and stops a procedure frame *)

PROCEDURE PushBlock (VAR save: INTEGER;  new := 0);
PROCEDURE PopBlock  (save: INTEGER);
(* starts and stops a local variable block *)

PROCEDURE NoteDeclaration (t: Type.T);

END Frame.
