(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: VarExpr.m3                                            *)
(* Last modified on Tue Jun 30 08:48:19 PDT 1992 by kalsow     *)
(*      modified on Sun Jan 21 10:57:47 1990 by muller         *)

MODULE VarExpr;

IMPORT Expr, ExprRep, Type, Value, Variable, String, Temp, MBuf;

TYPE
  P = Expr.T OBJECT
        v : Variable.T;
      OVERRIDES
        typeOf       := ExprRep.NoType;
        check        := Check;
        compile      := Compile;
        evaluate     := ExprRep.NoValue;
        fprint       := FPrinter;
        write        := ExprRep.NoWriter;
        isEqual      := EqCheck;
        getBounds    := ExprRep.NoBounds;
        isWritable   := ExprRep.IsAlways;
        isDesignator := ExprRep.IsAlways;
	isZeroes     := ExprRep.IsNever;
	note_write   := NoteWrites;
	genLiteral   := ExprRep.NoLiteral;
      END;

PROCEDURE New (t: Type.T;  name: String.T): Expr.T =
  VAR p: P;
  BEGIN
    p := NEW (P);
    ExprRep.Init (p);
    p.v := Variable.New (name, TRUE);
    p.type := Type.Base (t);
    Variable.BindType (p.v, t, FALSE, FALSE);
    RETURN p;
  END New;

PROCEDURE Obj (e: Expr.T): Variable.T =
  BEGIN
    TYPECASE e OF
    | NULL => RETURN NIL;
    | P(p) => RETURN p.v;
    ELSE      RETURN NIL;
    END;
  END Obj;

PROCEDURE Check (p: P;  VAR cs: Expr.CheckState) =
  BEGIN
    Value.TypeCheck (p.v, cs);
  END Check;

PROCEDURE EqCheck (a: P;  e: Expr.T): BOOLEAN =
  BEGIN
    TYPECASE e OF
    | NULL => RETURN FALSE;
    | P(b) => RETURN (a.v = b.v);
    ELSE      RETURN FALSE;
    END;
  END EqCheck;

PROCEDURE Compile (p: P): Temp.T =
  BEGIN
    RETURN Variable.Load (p.v);
  END Compile;

PROCEDURE NoteWrites (p: P) =
  BEGIN
    Variable.ScheduleTrace (p.v);
  END NoteWrites;

PROCEDURE FPrinter (p: P;  map: Type.FPMap;  wr: MBuf.T) =
  BEGIN
    Value.Fingerprint (p.v, map, wr);
  END FPrinter;

BEGIN
END VarExpr.
