#!/bin/sh
# An install script taken from some form of ULTRIX, since all other
# UNI*'s have only binaries and are incompatible
# Made a little bit smarter, to check for valid versions
# of mv, chmod, chown, chgrp and strip.
#						ElB 21.01.1993
# Test if we have a modern test, which knows -x
X=-x
[ -x /UpSaLa ] 2>/dev/null
[ $? = 255 ] && X=-f

chmod=""
[ $X /bin/chmod ]     && chmod=/bin/chmod
[ $X /usr/bin/chmod ] && chmod=/usr/bin/chmod
[ $X /etc/chmod ]     && chmod=/usr/etc/chmod
[ -z "$chmod" ]       && (echo Sorry, no valid chmod; exit 1)
strip=""
[ $X /bin/strip ]     && strip=/bin/strip
[ $X /usr/bin/strip ] && strip=/usr/bin/strip
[ $X /etc/strip ]     && strip=/usr/etc/strip
[ -z "$strip" ]       && (echo Sorry, no valid strip; exit 1)
chown=""
[ $X /bin/chown ]     && chown=/bin/chown
[ $X /usr/bin/chown ] && chown=/usr/bin/chown
[ $X /etc/chown ]     && chown=/usr/etc/chown
[ -z "$chown" ]       && (echo Sorry, no valid chown; exit 1)
chgrp=""
[ $X /bin/chgrp ]     && chgrp=/bin/chgrp
[ $X /usr/bin/chgrp ] && chgrp=/usr/bin/chgrp
[ $X /etc/chgrp ]     && chgrp=/usr/etc/chgrp
[ -z "$chgrp" ]       && (echo Sorry, no valid chgrp; exit 1)
rm=""
[ $X /bin/rm ]        && rm=/bin/rm
[ $X /usr/bin/rm ]    && rm=/usr/bin/rm
[ $X /etc/rm ]        && rm=/usr/etc/rm
[ -z "$rm" ]          && (echo Sorry, no valid rm; exit 1)
mv=""
[ $X /bin/mv ]        && mv=/bin/mv
[ $X /usr/bin/mv ]    && mv=/usr/bin/mv
[ $X /etc/mv ]        && mv=/usr/etc/mv
[ -z "$mv" ]          && (echo Sorry, no valid mv; exit 1)
cp=""
[ $X /bin/cp ]        && cp=/bin/cp
[ $X /usr/bin/cp ]    && cp=/usr/bin/cp
[ $X /etc/cp ]        && cp=/usr/etc/cp
[ -z "$cp" ]          && (echo Sorry, no valid cp; exit 1)

docmd=$mv
dorm=$rm
dochmod="$chmod 755"
dochown="$chown root"
dochgrp="$chgrp system"
while :
do
	case $1 in
	-s )	dostrip="$strip"
		;;
	-c )	docmd="$cp"
		;;
	-m )	dochmod="$chmod $2"
		shift
		;;
	-o )	dochown="$chown $2"
		shift
		;;
	-g )	dochgrp="$chgrp $2"
		shift
		;;
	* )	break
		;;
	esac
	shift
done

case "$2" in
"")	echo "install: no destination specified"
	exit 1
	;;
.|"$1")	echo "install: can't move $1 onto itself"
	exit 1
	;;
esac
case "$3" in
"")	;;
*)	echo "install: too many files specified -> $*"
	exit 1
	;;
esac
if [ -d $2 ]
then	file=$2/`basename $1`
else	file=$2
fi
$dorm -f $file
$docmd $1 $file
[ $dostrip ] && $dostrip $file
$dochmod $file
$dochgrp $file
$dochown $file
