/*
 * packet2ascii.c --
 *	Convert between binary and ASCII representation for finger packets.
 *
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: packet2ascii.c,v 1.4 1994/01/11 02:14:39 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <stdio.h>
#include <string.h>

#include "packet.h"
#include "util.h"

extern long atol();

#define ALTNAME		"ascii2packet"

#define PRINT_FORMAT	"%s%c%s%c%s%c%ld%c%ld%c%s%c%s%c%s\n"
#define SEPARATOR	'~'

static char *progname;

static int retcode = 0;

/*
 * read finger packets from stdin and print ASCII equivalent to stdout
 */
packet2ascii()
{
	FINGER_PACKET packet;

	while (fread((char *)&packet, sizeof(packet), 1, stdin) == 1) {
		printf(PRINT_FORMAT,
			packet.name, SEPARATOR,
			packet.real_name, SEPARATOR,
			packet.host, SEPARATOR,
			packet.login_time, SEPARATOR,
			packet.idle_time, SEPARATOR,
			packet.ttyname, SEPARATOR,
			packet.ttyloc, SEPARATOR,
			packet.what);
	}
}

char *
parse_string(line, sep, buffer, buflen, lineno, name)
	char *line;
	char sep;
	char *buffer;
	int buflen;
	int lineno;
	char *name;
{
	char *end;

	if (!line)
		return NULL;

	end = strchr(line, sep);

	if (!end) {
		fprintf(stderr, "%s: unterminated `%s' field at line %d\n",
			progname, name, lineno);
		return NULL;
	}

	*end = '\0';

	if (strlen(line) >= buflen) {
		fprintf(stderr, "%s: truncating field `%s' at line %d\n",
			progname, name, lineno);
	}

	bzero(buffer, buflen);
	strncpy(buffer, line, buflen);
	buffer[buflen - 1] = '\0';

	return (end + 1);
}

char *
parse_time(line, sep, buffer, lineno, name)
	char *line;
	char sep;
	time_t *buffer;
	int lineno;
	char *name;
{
	char *end;

	if (!line)
		return NULL;

	end = strchr(line, sep);

	if (!end) {
		fprintf(stderr, "%s: unterminated `%s' field at line %d\n",
			progname, name, lineno);
		return NULL;
	}

	*buffer = (time_t) atol(line);

	return (end + 1);
}

ascii2packet()
{
	FINGER_PACKET packet;
	char linebuf[USERNAME_LEN + REALNAME_LEN + HOSTNAME_LEN + 10 + 10 +
			TTYNAME_LEN + TTYLOC_LEN + WHAT_LEN + 10];
	int lineno = 0;

	while (fgets(linebuf, sizeof(linebuf), stdin)) {
		char *p;

		lineno++;
		p = linebuf;

		p = parse_string(p, SEPARATOR,
				packet.name, sizeof(packet.name),
				lineno, "name");
		p = parse_string(p, SEPARATOR,
				packet.real_name, sizeof(packet.real_name),
				lineno, "real_name");
		p = parse_string(p, SEPARATOR,
				packet.host, sizeof(packet.host),
				lineno, "host");
		p = parse_time(p, SEPARATOR,
				&packet.login_time,
				lineno, "login_time");
		p = parse_time(p, SEPARATOR,
				&packet.idle_time,
				lineno, "idle_time");
		p = parse_string(p, SEPARATOR,
				packet.ttyname, sizeof(packet.ttyname),
				lineno, "ttyname");
		p = parse_string(p, SEPARATOR,
				packet.ttyloc, sizeof(packet.ttyloc),
				lineno, "ttyloc");
		p = parse_string(p, '\n',
				packet.what, sizeof(packet.what),
				lineno, "what");

		if (! p)
		 	retcode = 1;
		else
			fwrite((char *)&packet, sizeof(packet), 1, stdout);
	}
}

main(argc, argv)
	int argc;
	char *argv[];
{
	if (progname = strrchr(argv[0], '/'))
		progname++;
	else
		progname = argv[0];

	if (strcmp(progname, ALTNAME) == 0)
		ascii2packet();
	else
		packet2ascii();

	exit(retcode);
}
