/*
 * finger.c --
 *	The program that users directly interact with.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: finger.c,v 1.11 1993/02/02 23:42:10 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <stdio.h>
#include <string.h>

#include "general.h"
#include "error.h"
#include "call.h"


/* **************************************************************** */
/*								    */
/*			      "finger"				    */
/*								    */
/* **************************************************************** */

/* Our version of "finger". */

main (argc, argv)
     int argc;
     char **argv;
{
  int args_found, arg_index;
  long options;
  char *widtharg = NULL;

  
  default_error_handling (argv[0], stderr);

  /* Parse the arguments passed on the command line. */
  options = 0;
  arg_index = 1;
  args_found = 0;

  while (arg_index != argc)
    {
      char *arg = argv[arg_index++];

      if (strcmp (arg, "-face") == 0)
	{
	  options |= FACE;
	  continue;
	}
      else if (strcmp (arg, "-info") == 0 || strcmp (arg, "-l") == 0)
	{
	  options |= INFO;
	  continue;
	}
      else if (strcmp (arg, "-width") == 0)
        {
	  options |= WIDTH;
	  widtharg = argv[arg_index++];
	  continue;
	}

      args_found++;
      call_finger (arg, options, widtharg);

      /* You have to specify "-face" before each user who is to be faced. */
      options &= ~FACE;
    }

  if (!args_found)
    call_finger ("", options, widtharg);

  exit(0);
}

