/*
 * x_show_face.c --
 *	The way to display a face bitmap in the X window system.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: x_show_face.c,v 1.20 1994/03/16 21:48:57 stolcke Exp $ ICSI (Berkeley)";
#endif


#include "../config.h"

#ifdef HAVE_X11 

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/Form.h>

#include "general.h"
#include "call.h"
#include "bitmap.h"
#include "error.h"
#include "util.h"

BITMAP *the_face;
char *the_user;

/* Main display interface. */

/* The X display. */
Display *the_display;

/* The graphic context that we are using. */
GC image_GC = (GC)NULL;

/* Widgets and friends. */
Widget toplevel;
Widget   quit_button;		/* Calls Quit (). */
Widget   image_model_form;
Widget     image_form;
Widget       image_port;
Widget         image_box;
Pixmap            image_bitmap, face_bitmap = (Pixmap)None;
Widget     finger_button;	/* Calls Finger (). */
Widget	   save_button;		/* Calls Save (). */
#ifdef PRINT_WIDGET
Widget	   print_button;	/* Calls Print (). */
#endif

#define min(a, b) ((a) < (b) ? (a) : (b))
#define max(a, b) ((a) > (b) ? (a) : (b))

/*
 * ArgLists for various widgets
 */
static Arg im_form_args[] =
{
  XtNwidth, (XtArgVal) 0,
  XtNheight, (XtArgVal) 0,
  XtNx, (XtArgVal) 100,
  XtNy, (XtArgVal) 100
};

static Arg image_form_args[] =
{
  XtNwidth, (XtArgVal) 0,
  XtNheight, (XtArgVal) 0,
  XtNborderWidth, (XtArgVal) 3,
};

static Arg image_port_args[] =
{
  XtNwidth, (XtArgVal) 0,
  XtNheight, (XtArgVal) 0,
  XtNforceBars, (XtArgVal) False,
  XtNallowHoriz, (XtArgVal) False,
  XtNallowVert, (XtArgVal) False
  };

Arg image_args[] =
{
  XtNwidth, (XtArgVal) 0,
  XtNheight, (XtArgVal) 0,
  XtNbackgroundPixmap, (XtArgVal) NULL
};

/*
 * Fallback resources
 */
static char *fb_resource[] = {
"Finger*topForm.saveButton.label:	Save",
"Finger*topForm.saveButton.top:		chaintop",
"Finger*topForm.saveButton.left:	chainleft",
"Finger*topForm.saveButton.right:	chainleft",
"Finger*topForm.saveButton.bottom:	chaintop",

#ifdef PRINT_WIDGET
"Finger*topForm.printButton.label:	Print",
"Finger*topForm.printButton.top:	chaintop",
"Finger*topForm.printButton.left:	chainleft",
"Finger*topForm.printButton.right:	chainleft",
"Finger*topForm.printButton.bottom:	chaintop",
"Finger*topForm.printButton.fromHoriz:	saveButton",
#endif /* PRINT_WIDGET */

"Finger*topForm.quitButton.label:	Quit",
"Finger*topForm.quitButton.top:		chaintop",
"Finger*topForm.quitButton.left:	chainleft",
"Finger*topForm.quitButton.right:	chainleft",
"Finger*topForm.quitButton.bottom:	chaintop",
#ifdef PRINT_WIDGET
"Finger*topForm.quitButton.fromHoriz:	printButton",
#else
"Finger*topForm.quitButton.fromHoriz:	saveButton",
#endif

"Finger*topForm.imageForm.top:		chaintop",
"Finger*topForm.imageForm.left:		chainleft",
"Finger*topForm.imageForm.right:	chainleft",
"Finger*topForm.imageForm.bottom:	chaintop",
"Finger*topForm.imageForm.fromVert:	saveButton",

"Finger*topForm.fingerButton.label:	finger",
"Finger*topForm.fingerButton.top:	chaintop",
"Finger*topForm.fingerButton.left:	chainright",
"Finger*topForm.fingerButton.right:	chainright",
"Finger*topForm.fingerButton.bottom:	chaintop",
"Finger*topForm.fingerButton.fromVert:	saveButton",
"Finger*topForm.fingerButton.fromHoriz:	imageForm",

"Finger*fingerForm.fingerText*font:		6x10",
"Finger*fingerForm.fingerText.width:		480",
"Finger*fingerForm.fingerText.height:		240",
"Finger*fingerForm.fingerText.scrollVertical:	whenNeeded",
"Finger*fingerForm.fingerText.scrollHorizontal:	whenNeeded",
"Finger*fingerForm.fingerText.top:		chaintop",

"Finger*fingerForm*quitFingerButton.label:	Dismiss",
"Finger*fingerForm.quitFingerButton.top:	chaintop",
"Finger*fingerForm.quitFingerButton.fromHoriz:	fingerText",

NULL
};

/*
 * Callback functions
 */
/*ARGSUSED*/
void
Quit (w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
  exit (0);
}

/*ARGSUSED*/
void
QuitFinger (w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
  XtPopdown((Widget)client_data);
  XtDestroyWidget((Widget)client_data);
}

/*ARGSUSED*/
void
Finger (w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
  static char tmpfile[] = "/tmp/fingerXXXXXX";
  extern char *mktemp();

  /*
   * Widget subhierarchy for finger popup
   */
  Widget   finger_shell;
  Widget     finger_form;
  Widget        quitf_button;
  Widget	      finger_text;
  char *label;		/* popup title */

  /*
   * ArgList for text widget showing finger data
   */
  static Arg finger_text_args[] =
  {
    XtNtype, (XtArgVal) XawAsciiFile,
    XtNstring, (XtArgVal) NULL,
    XtNeditType, (XtArgVal) XawtextRead,
  };

  /*
   * Collect finger output in file
   */
  if (!mktemp(tmpfile))
    {
      warning("cannot create temp file %s", tmpfile);
      return;
    }

  if (!freopen(tmpfile, "w", stdout))
    {
      file_error(WARNING, tmpfile);
      return;
    }

  call_finger(the_user, INFO);
  (void)freopen("/dev/null", "w", stdout);

  /*
   * Create popup and widgets
   */
  label = xmalloc(strlen(the_user) + 8);
  sprintf(label, "finger %s", the_user);

  finger_shell = XtCreatePopupShell(label, wmShellWidgetClass,
			toplevel, (ArgList)NULL, 0);
  free(label);

  finger_form = XtCreateManagedWidget ("fingerForm", formWidgetClass,
			finger_shell, (ArgList)NULL, 0);

  finger_text_args[1].value = (XtArgVal)tmpfile;
  finger_text = XtCreateManagedWidget ("fingerText", asciiTextWidgetClass,
			finger_form, finger_text_args,
			XtNumber (finger_text_args));

  quitf_button = XtCreateManagedWidget ("quitFingerButton", commandWidgetClass,
			finger_form, (ArgList)NULL, 0);
  XtAddCallback(quitf_button, XtNcallback, QuitFinger, (XtPointer)finger_shell);

  XtRealizeWidget(finger_shell);
  XtPopup(finger_shell, XtGrabNone);
  
  unlink(tmpfile);
  return;
}

/*ARGSUSED*/
void
Save (w, client_data, call_data)
     Widget w;
     XtPointer client_data, call_data;
{
  if (site_save_face (the_user, the_face))
    file_error (WARNING, the_user);
}

#ifdef PRINT_WIDGET
/*ARGSUSED*/
void
Print (w, client_data, call_data)
     Widget w;
     XtPointer client_data, call_data;
{
  (void)site_print_face (the_user, the_face);
}
#endif /* PRINT_WIDGET */

#define WIDE 1024
#define TALL 600

int
x_show_face (user_name, face)
     char *user_name;
     BITMAP *face;
{
  int one = 1;
  XtAppContext app_ctxt;

  char *empty_array[2];

  int width = face->width;
  int height = face->height;

  int uwidth = min (width, WIDE);
  int uheight = min (height, TALL);

  the_face = face;
  the_user = user_name;

  if (width > uwidth)
      image_port_args[2].value = image_port_args[3].value = (XtArgVal)True;
  
  if (height > uheight)
      image_port_args[2].value = image_port_args[4].value = (XtArgVal)True;
      
  image_args[0].value = width;
  image_args[1].value = height;
  image_args[2].value = (XtArgVal) (Pixmap)NULL;
 
  im_form_args[0].value = uwidth;
  im_form_args[1].value = uheight + 40;

  image_form_args[0].value = uwidth;
  image_form_args[1].value = uheight + 30;

  image_port_args[0].value = uwidth;
  image_port_args[1].value = uheight;

  empty_array[0] = "finger";
  empty_array[1] = (char *)NULL;
  one=1;

  toplevel = XtVaAppInitialize(&app_ctxt, "Finger", NULL,  0, &one,
                               empty_array, fb_resource,
                               XtNtitle, user_name, NULL);

  image_model_form = XtCreateManagedWidget ("topForm", formWidgetClass,
			 toplevel, im_form_args, XtNumber (im_form_args));

  save_button = XtCreateManagedWidget ("saveButton", commandWidgetClass,
			image_model_form, (ArgList)NULL, 0);
  XtAddCallback (save_button, XtNcallback, Save, (XtPointer)NULL);

#ifdef PRINT_WIDGET
  print_button = XtCreateManagedWidget ("printButton", commandWidgetClass,
			image_model_form, (ArgList)NULL, 0);
  XtAddCallback (print_button, XtNcallback, Print, (XtPointer)NULL);
#endif
  quit_button = XtCreateManagedWidget ("quitButton", commandWidgetClass,
			image_model_form, (ArgList)NULL, 0);
  XtAddCallback (quit_button, XtNcallback, Quit, (XtPointer)NULL);

  image_form = XtCreateManagedWidget ("imageForm", boxWidgetClass,
			image_model_form, image_form_args,
			XtNumber (image_form_args));

  finger_button = XtCreateManagedWidget ("fingerButton", commandWidgetClass,
			image_model_form, (ArgList)NULL, 0);
  XtAddCallback (finger_button, XtNcallback, Finger, (XtPointer)NULL);

  image_port = XtCreateManagedWidget ("imagePort", viewportWidgetClass,
			image_form, image_port_args,
			XtNumber (image_port_args));

  the_display = XtDisplay (image_port);

  {
    unsigned long fg_color = BlackPixelOfScreen (XtScreen (image_port));
    unsigned long bg_color = WhitePixelOfScreen (XtScreen (image_port));

    image_box = XtCreateManagedWidget ("imagePicture", boxWidgetClass,
			image_port, image_args, XtNumber (image_args));
  

    XtRealizeWidget (toplevel);

    face_bitmap = XCreatePixmapFromBitmapData (the_display,
			XtWindow (image_box), (char *)face->bits,
			width, height,
			fg_color, bg_color,
			DefaultDepth(the_display, DefaultScreen(the_display)));

    image_GC = XCreateGC (the_display, face_bitmap, (long)0, (XGCValues *)NULL);
    

    XSetForeground (the_display, image_GC, fg_color);
    XSetBackground (the_display, image_GC, bg_color);
  }

  XSetWindowBackgroundPixmap (the_display, XtWindow (image_box), face_bitmap);
  XClearWindow(the_display, XtWindow(image_box));

  XtAppMainLoop (app_ctxt);
  return (0);
}

#endif /* HAVE_X11 */
