/*
 * sun_show_face.c --
 *	How to show a face on a sun.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: sun_show_face.c,v 1.11 1993/09/16 00:27:46 stolcke Exp $ ICSI (Berkeley)";
#endif

#include "../config.h"

#ifdef HAVE_SUNVIEW

#include <stdio.h>
#include <string.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <suntool/textsw.h>

#include "general.h"
#include "call.h"
#include "bitmap.h"
#include "error.h"
#include "util.h"

/* client data structure holding info for callback procedures */
struct userdata {
  BITMAP *face;
  char *user;
};

static Frame baseframe;

/*ARGSUSED*/
static int
finger_proc(item, event)
  Panel_item item;
  Event *event;
{
  struct userdata *userface =
	(struct userdata *)panel_get(item, PANEL_CLIENT_DATA);
  static char tmpfile[] = "/tmp/fingerXXXXXX";
  Frame textframe;
  static Textsw textsw;
  char *label;
  extern char *mktemp();

  if (!mktemp(tmpfile))
    {
      warning("cannot create temp file %s", tmpfile);
      return (-1);
    }

  if (!freopen(tmpfile, "w", stdout))
    {
      file_error(WARNING, tmpfile);
      return (-1);
    }

  call_finger(userface->user, INFO);
  (void)freopen("/dev/null", "w", stdout);

  label = xmalloc(strlen(userface->user) + 8);
  sprintf(label, "finger %s", userface->user);

  textframe = window_create(baseframe, FRAME,
		FRAME_LABEL, label,
		FRAME_SHOW_LABEL, TRUE,
		FRAME_NO_CONFIRM, TRUE,
		WIN_SHOW, TRUE,
		0);
  free(label);

  if (!textframe)
    return (-1);

  textsw = window_create(textframe, TEXTSW,
	WIN_COLUMNS, 85,
	WIN_ROWS, 24,
	TEXTSW_FILE, tmpfile,
	TEXTSW_READ_ONLY, TRUE,
	0);
  
  window_fit(textframe);

  unlink(tmpfile);
  return (0);
}

/*ARGSUSED*/
static int
save_proc(item, event)
  Panel_item item;
  Event *event;
{
  struct userdata *userface =
	(struct userdata *)panel_get(item, PANEL_CLIENT_DATA);

  if (site_save_face (userface->user, userface->face))
    file_error (WARNING, userface->user);

  return (0);
}

#ifdef PRINT_WIDGET
/*ARGSUSED*/
print_proc(item, event)
  Panel_item item;
  Event *event;
{
  struct userdata *userface =
	(struct userdata *)panel_get(item, PANEL_CLIENT_DATA);
	
  (void)site_print_face (userface->user, userface->face);

  return (0);
}
#endif /* PRINT_WIDGET */

/*ARGSUSED*/
static int
quit_proc(item, event)
  Panel_item item;
  Event *event;
{
  Frame frame = (Frame)panel_get(item, PANEL_CLIENT_DATA);

  window_set(frame, FRAME_NO_CONFIRM, TRUE, 0);
  window_destroy(frame);

  return (0);
}

/* Display FACE of USER in a SunView window. */
int
sun_show_face (user, face)
     char *user;
     BITMAP *face;
{
  int height, width;
  int size;
  struct pixrect *image;
  Canvas canvas;
  Panel panel;
  Pixwin *pw;
  struct userdata userface;

  /* Sun pixmaps are on 4 byte boundaries. */
  pad_face (face, 4);
  reverse_image_bit_order (face);

  height = face->height;
  width = face->width;
  size = face->rowlen * height;

  /* ras_depth is always 1 for black and white. */
  image = mem_create (width, height, 1);
  if (!image)
    {
      fprintf(stderr, "no memory for image\n");
      return (1);
    }

  bcopy (face->bits, mpr_d (image)->md_image, size);
  reverse_image_bit_order (face);

  baseframe = window_create(NULL, FRAME,
		FRAME_LABEL, user,
		0);

  if (!baseframe)
    {
      pr_destroy (image);
      return (1);
    }

  /*
   * Create the canvas containing the image
   */
  canvas = window_create(baseframe, CANVAS,
		WIN_HEIGHT, height,
		WIN_WIDTH, width,
		0);
  pw = canvas_pixwin(canvas);

  pw_write (pw, 0, 0, width, height, PIX_SRC, image, 0, 0);
  pr_destroy (image);

  /*
   * Create a panel containing various buttons
   */
  panel = window_create(baseframe, PANEL,
		WIN_COLUMNS, 1,
		0);

  userface.user = user;
  userface.face = face;

  panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "finger", 0, 0),
		PANEL_NOTIFY_PROC, finger_proc,
		PANEL_CLIENT_DATA, (caddr_t)&userface,
		0);

#ifdef PRINT_WIDGET
  panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Print", 0, 0),
		PANEL_NOTIFY_PROC, print_proc,
		PANEL_CLIENT_DATA, (caddr_t)&userface,
		0);
#endif /* PRINT_WIDGET */

  panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Save", 0, 0),
		PANEL_NOTIFY_PROC, save_proc,
		PANEL_CLIENT_DATA, (caddr_t)&userface,
		0);

  panel_create_item(panel, PANEL_BUTTON,
		PANEL_LABEL_IMAGE, panel_button_image(panel, "Quit", 0, 0),
		PANEL_NOTIFY_PROC, quit_proc,
		PANEL_CLIENT_DATA, (caddr_t)baseframe,
		0);

  window_fit(panel);
  window_fit(baseframe);
  window_main_loop(baseframe);
  return (0);
}

#ifdef TEST

#include <sys/types.h>
#include <sys/file.h>

main (argc, argv)
     int argc;
     char **argv;
{
  int arg_index = 1;

  while (--argc)
    get_face_and_display (*++argv);
}

get_face_and_display (filename)
     char *filename;
{
  struct rasterfile header;
  BITMAP *face;
  int f, size;

  f = open (filename, O_RDONLY);
  if (f < 0)
    {
      file_error (FATAL, filename);
    }

  read (f, &header, sizeof (struct rasterfile));

  if (header.ras_magic != RAS_MAGIC)
    {
      handle_error (FATAL, "%s: not a rasterfile.\n", filename);
    }

  if (header.ras_depth != 1)
    {
      handle_error (FATAL, "%s: Can't hack %d bit deep rasterfiles.\n",
	       filename, header.ras_depth);
    }

  face = (BITMAP *)malloc (sizeof (BITMAP));
  face->width = header.ras_width;
  face->height = header.ras_height;
  face->rowlen = ((face->width + 15) / 16) * 2;
  size = face->rowlen * face->height;
  face->bits = (unsigned char *)malloc (size);

  lseek (f, header.ras_maplength, 1);
  read (f, face->bits, size);

  {
    char *user = strrchr (filename, '/');
    register int i;

    if (user)
      user++;
    else
      user = filename;

    for (i = 0; i < size; i++)
      face->bits[i] = ~face->bits[i];

    sun_show_face (user, face);
    free (face->bits);
    free (face);
  }
}

void
pad_face () {}

#endif  /* TEST */
#endif /* HAVE_SUNVIEW */
