/*
 * save_x_bitmap.c --
 *	Write out the face as an X11 bitmap file.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: save_x_bitmap.c,v 1.8 1993/05/28 19:28:48 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "general.h"
#include "bitmap.h"
#include "error.h"

/* Save the bitmap in FACE to the mugshot file for USER.
   Return zero if successful, file system error code if not. */
int 
save_x_bitmap (user, face)
     char *user;
     BITMAP *face;
{
  char *filename, *bitmapname, *p;
  FILE *file;
  int x, y, fcol;

  filename = mugshot_filename (user, NULL);

  file = fopen (filename, "w");
  free (filename);

  if (!file)
    return (errno);

  /* The bitmap's name is the username stripped of the hostname */
  bitmapname = savestring (user);
  if (p = strchr (bitmapname, '@'))
    *p = '\0';

  /* Write out standard header */
  fprintf (file, "/* Face bitmap for %s, written by GNU Finger. */\n", user);
  fprintf (file, "#define %s_width %d\n", bitmapname, face->width);
  fprintf (file, "#define %s_height %d\n", bitmapname, face->height);
  fprintf (file, "static char %s_bits[] = {", bitmapname);
  free (bitmapname);

  /* Print out the data itself. */
  fcol = 12;
  for (y = 0; y < face->height; y++)
    {
      byte *row = face->bits + (face->rowlen * y);

      for (x = 0; x < face->rowlen; x++)
	{
	  if (x || y)
	    fprintf (file, ",");

	  if (fcol == 12)
	    {
	      fprintf (file, "\n   ");
	      fcol = 0;
	    }

	  fprintf (file, "0x%02x", row[x]);
	  fcol++;
	}
    }
  fprintf (file, "};\n");
  fclose (file);
  return (0);
}
