/*
 * save_rasterfile.c --
 *	How to save a bitmap as a Sun rasterfile image.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: save_rastfile.c,v 1.9 1993/09/16 00:27:46 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>

#include "general.h"
#include "bitmap.h"
#include "error.h"

#ifdef HAVE_RASTERFILE
#include <rasterfile.h>
#else
struct rasterfile {
  int ras_magic, ras_width, ras_height, ras_depth, ras_length;
  int filler1, filler2;
  int ras_maplength;
};
/* Today.  I don't know what it is tommorrow. */
#define RAS_MAGIC 0X59A66A95
#endif /* HAVE_RASTERFILE */

int
save_rasterfile (user, face)
     char *user;
     BITMAP *face;
{
  char *filename = mugshot_filename (user, NULL);
  struct rasterfile header;
  int file;

  file = open (filename, O_WRONLY | O_TRUNC | O_CREAT, 0666);
  free (filename);

  if (file < 0)
    return (errno);

  pad_face (face, 2);

  bzero (&header, sizeof (header));

  header.ras_magic = RAS_MAGIC;
  header.ras_width = face->width;
  header.ras_height = face->height;
  header.ras_depth = 1;
  header.ras_length = face->rowlen * face->height;
  header.ras_maplength = 0;

  write (file, &header, sizeof (header));

  reverse_image_bit_order (face);
  write (file, face->bits, header.ras_length);
  reverse_image_bit_order (face);

  close (file);

  return (0);
}


  
