/*
 * save_lispmug.c --
 *	Save FACE as a MIT Lispm Mugshot.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: save_lispmug.c,v 1.8 1993/12/16 10:39:56 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>

#include "general.h"
#include "bitmap.h"
#include "error.h"

struct lispmug {
  short width;
  short height;
};

int
save_lispmug (user, face)
     char *user;
     BITMAP *face;
{
  char *filename;
  struct lispmug header;
  int file, size, i;
  byte *bits;

  filename = mugshot_filename (user, NULL);
  file = open (filename, O_WRONLY | O_CREAT | O_TRUNC, 0666);
  free (filename);

  if (!file)
    return (errno);

  header.width = face->width;
  header.height = face->height;

  BYTESWAP (header.width);
  BYTESWAP (header.height);

  pad_face (face, 4);
  size = face->rowlen * face->height;
  bits = (byte *)xmalloc (size);
  bcopy (face->bits, bits, size);
  pad_face (face, 1);

  for (i = 0; i < size; i++)
    bits[i] = ~(bits[i]);

  write (file, &header, sizeof (header));
  write (file, bits, size);

  close (file);
  return (0);
}
