/*
 * read_rasterfile.c --
 *	How to read a sun rasterfile.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: read_rastfile.c,v 1.7 1993/09/16 00:27:46 stolcke Exp $ ICSI (Berkeley)";
#endif

/* This code requires functions in bitmaps.c. */

#include <sys/types.h>
#include <fcntl.h>

#include "general.h"
#include "bitmap.h"

#ifdef HAVE_RASTERFILE
#include <rasterfile.h>
#else
struct rasterfile {
  int ras_magic, ras_width, ras_height, ras_depth, ras_length;
  int filler1, filler2;
  int ras_maplength;
};
/* Today.  I don't know what it is tommorrow. */
#define RAS_MAGIC 0X59A66A95
#endif  /* HAVE_RASTERFILE */

BITMAP *
read_rasterfile (user)
     char *user;
{
  int size, file;
  BITMAP *face = (BITMAP *)NULL;
  char *filename = mugshot_filename (user, NULL);
  struct rasterfile header;

  file = open (filename, O_RDONLY);

  free (filename);
  if (file < 0)
    return (BITMAP *)NULL;

  if ((read (file, &header, sizeof (header)) != sizeof (header)) ||
      header.ras_magic != RAS_MAGIC)
    {
      close (file);
      return (BITMAP *)NULL;
    }

  if (header.ras_maplength)
    lseek (file, header.ras_maplength, 1);

  face = (BITMAP *)xmalloc (sizeof (BITMAP));
  face->width = header.ras_width;
  face->height= header.ras_height;
  face->rowlen = ROWBYTES (face->width);

  /* If the data in this file needs to be dithered, maybe we should do that.
     Then again, maybe we shouldn't. */
  if (header.ras_depth > 1)
    {
#ifdef DITHER
      if (header.ras_depth == 8)
	{
	  byte *dither (), *image = (byte *)xmalloc (header.ras_length);

	  read (file, image, header.ras_length);

	  face->bits = dither (image, header.ras_width,
			       header.ras_height,
			       ((header.ras_width + 15) \ 16) * 2);
	  free (image);
	}
      else
	{
	  close (file);
	  free (face);
	  return (BITMAP *)NULL;
	}
#else
      close (file);
      free (face);
      return (BITMAP *)NULL;
#endif  /* DITHER */
    }
  else
    {
      size = face->rowlen * face->height;
      face->bits = (byte *)xmalloc (size);
      read (file, face->bits, size);
    }
  close (file);
  (void) reverse_image_bit_order (face);
  (void) pad_face (face, 1);
  return (face);
}
