/*
 * read_lispmug.c --
 *	How to read a face in MIT Lispm mugshot format.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: read_lispmug.c,v 1.7 1993/12/16 10:39:56 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <sys/types.h>
#include <fcntl.h>

#include "general.h"
#include "bitmap.h"

struct lispmug {
  short width;
  short height;
};

BITMAP *
read_lispmug (user)
     char *user;
{
  int size, file;
  BITMAP *face = (BITMAP *)NULL;
  char *filename = mugshot_filename (user, NULL);
  struct lispmug header;

  file = open (filename, O_RDONLY);

  free (filename);

  if (file < 0)
    return (BITMAP *)NULL;

  if (read (file, &header, sizeof (header)) != sizeof (header))
    {
      close (file);
      return (BITMAP *)NULL;
    }

  BYTESWAP (header.width);
  BYTESWAP (header.height);

  face = (BITMAP *)xmalloc (sizeof (BITMAP));
  face->width = header.width;
  face->height = header.height;
  face->rowlen = ((header.width + 31) / 32) * 4;

  size = face->rowlen * face->height;
  face->bits = (byte *)xmalloc (size);
  read (file, face->bits, size);

  close (file);

  (void) pad_face (face, 1);
  (void) invert_image_bits (face);
  return (face);
}

#ifdef TEST
#if defined NULL
#undef NULL
#endif
#include <stdio.h>

/* Load a Lispm mugshot file from disk and display it. */

main (argc, argv)
     int argc;
     char **argv;
{
  int arg_index = 1;

  while (arg_index != argc)
    {
      char *file = argv[arg_index++];
      BITMAP *face = read_lispmug (file);

      if (face)
	{
	  x_show_face (file, face);
	  free (face->bits);
	  free (face);
	}
      else
	fprintf (stderr, "No face bits for `%s'.\n", file);
      
    }
}

site_save_face () {}

#endif


