/*
 * getservhost.c --
 *	Return the name of the server host.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: getservhost.c,v 1.12 1993/01/29 03:47:53 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <stdio.h>

#include "general.h"
#include "util.h"
#include "error.h"
#include "getservhost.h"

/* Return a new string which is the name of the local GNU Finger server
   host.  If this cannot be determined, return a NULL pointer instead. */
char *
getservhost (flags)
     int flags;
{
  char *serverhost = NULL;

  (void)open_host_config ();

  /* If we're looking for the local server, try that first. */
  if (!(flags & GETSERV_GLOBAL))
    serverhost = get_config_entry ("lserver", NULL);

  if (!serverhost)
    {
      open_host_config ();	/* rewind */
      serverhost = get_config_entry ("server", NULL);
    }

  if (!serverhost && !(flags & GETSERV_NOERROR))
    handle_error (FATAL, "no server entry found");
  
  return (serverhost);
}
