/*
 * face-finger.c --
 *	How and what faces look like in GNU Finger.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: face-finger.c,v 1.6 1992/09/03 18:40:42 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <stdio.h>

#include "general.h"
#include "bitmap.h"

/* **************************************************************** */
/*								    */
/*			`Fac'ing up to things.			    */
/*								    */
/* **************************************************************** */

/* Tell CONNECTION to send us the face for USER, and then display that
   face.  Returns non-zero if CONNECTION had a face for USER. */
int
face_finger (user, connection, fullname)
     char *user;
     int connection;
     char *fullname;
{
  BITMAP *face, *get_face_bits ();

  face = get_face_bits (user, connection);

  if (!face)
    return (0);

  site_show_face (fullname, face);
  free (face->bits);
  free (face);
  return (1);
}

/* Read a BITMAP * from CONNECTION.  USER is the name of the user to
   read the bits for. */
BITMAP *
get_face_bits (user, connection)
     char *user;
     int connection;
{
  FILE *stream;
  int fd;

  register int i;
  register byte *bits;

  int width, height, rowlen, size;

  BITMAP *output = (BITMAP *)NULL;

  fd = dup (connection);

  if ((stream = fdopen (fd, "r+")) == (FILE *)NULL)
    return ((BITMAP *)NULL);

  fprintf (stream, ":%s:\r\n", user);
  fflush (stream);
  fseek (stream, 0l, 1);

  /* Find out how much info is on the way. */

  if (fscanf (stream, "%d,%d,%d\r\n", &width, &height, &rowlen) != 3)
    {
      fclose (stream);
      return ((BITMAP *)NULL);
    }

  /* Okay, now get the bits. */

  size = rowlen * height;

  output = (BITMAP *)xmalloc (sizeof (BITMAP));
  output->width = width;
  output->height = height;
  output->rowlen = rowlen;
  output->bits = (byte *)xmalloc (size);

  for (i = 0, bits = output->bits; i < height; i++, bits += rowlen)
    fread (bits, 1, rowlen, stream);

  fclose (stream);
  return (output);
}
