/*
 * call.c --
 *	Call the finger daemon to actually do the fingering.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: call.c,v 1.13 1994/01/11 03:04:21 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/file.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "general.h"
#include "tcp.h"
#include "error.h"
#include "face-finger.h"
#include "text-finger.h"
#include "call.h"
#include "util.h"

/*VARARGS2*/
call_finger (arg, options, widtharg)
     char *arg;
     long options;
     char *widtharg;
{
  char *username, *hostname;
  int verbose = 0;
  struct hostent *host;
  int connection, facing, info, width;
  struct in_addr addr;

  username = savestring (arg);
  facing = options & FACE;
  info = options & INFO;
  width = (options & WIDTH) && (widtharg != NULL);

  hostname = strrchr(username, '@');	/* parse from behind */

  if (hostname)
    {
      verbose = 1;
      *hostname++ = '\0';
    }

  if (!hostname || !*hostname )
    hostname = LOCALHOST;

  if (isdigit (*hostname))
    {
      addr.s_addr = inet_addr (hostname);
      host = gethostbyaddr ((char *)&addr, sizeof(addr), AF_INET);
    }
  else
    {
      host = gethostbyname (hostname);
      
      if (!host)
	handle_error (FATAL, "%s: unknown host", hostname);

      bcopy (host->h_addr, &addr, sizeof(addr));
    }

  /* use canonical host name in messages */
  if (host)
    hostname = host->h_name;

  if (verbose)
    {
      printf ("[%s]\n", hostname);
      fflush (stdout);
    }

  connection = tcp_to_service ("finger", &addr);

  if (connection < 0)
    file_error (WARNING, hostname);

  /* Okay, connection established.  Now actually do the fingering. */
  if (facing)
    {
      if (!face_finger (username, connection, arg))
	warning ("%s doesn't have face bits for %s", hostname, username);
    }
  else
    {
      char *newuser = (char *)xmalloc(strlen(username) + 1 +
				    sizeof(WIDE_FLAG) +
				    sizeof(WIDTH_FLAG) +
				    (width ? strlen(widtharg) : 0));
			
      sprintf (newuser, "%s%s%s%s%s%s",
	       (info ? WIDE_FLAG : ""),
	       (info ? " " : ""),
	       (width ? WIDTH_FLAG : ""),
	       (width ? widtharg : ""),
	       (width ? " " : ""),
               username);
               
      text_finger (newuser, connection);
      free (newuser);
    }

  close (connection);
  free (username);
}
