/*
 * packet.h -- 
 *	Data structure of a packet.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: packet.h,v 1.11 1994/01/11 02:15:02 stolcke Exp $ ICSI (Berkeley)
 */

#if !defined (_PACKET_H_)
#define _PACKET_H_

#include <sys/types.h>

/* Length of the informative items that are returned in a FINGER_PACKET. */
#define USERNAME_LEN 16
#define HOSTNAME_LEN 64
#define REALNAME_LEN 64
#define TTYNAME_LEN 32
#define TTYLOC_LEN 128
#define WHAT_LEN 16

/* What a packet of finger information from a client looks like.  Note that
   times are stored in 32 bits of SECONDS.  Absolute time values are stored
   as seconds since 1970. */
typedef struct {
  char name[USERNAME_LEN];
  char real_name[REALNAME_LEN];
  char host[HOSTNAME_LEN];
  time_t login_time;
  time_t idle_time;
  char ttyname[TTYNAME_LEN];
  char ttyloc[TTYLOC_LEN];
  char what[WHAT_LEN];
} FINGER_PACKET;

/* Strings used in dummy packets to signal host is free or down */
#define HOST_NOUSERS	"Host has no users"
#define HOST_DOWN	"Host is down"

FINGER_PACKET **read_packets (), **finger_at_address ();
int write_packets ();

int remove_packets (), uniq_packets ();
void sort_packets ();

void print_packet (), ascii_packet ();
void set_print_widths ();

#endif /* _PACKET_H_ */

