/*
 * os.h --
 *	Routines defined in os.c
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: os.h,v 1.16 1994/01/11 02:15:02 stolcke Exp $ ICSI (Berkeley)
 */

#if !defined (_OS_H_)
#define _OS_H_

#include "packet.h"

/* Local hostname */
extern char localhost[];

/* Return a NULL terminated array of (FINGER_PACKET *) which represents
   the list of interesting users on *this* machine.  Single argument
   ALL_USERS when zero means don't place any user in the output list twice. */
FINGER_PACKET **get_finger_data ();

/* Return a NULL terminated array of (FINGER_PACKET *) which represents
   the list of last logins on *this* machine. */
FINGER_PACKET ** get_lastlog_data ();


/* Find local host's DNS domain */
char *get_domain_name ();

/* Get local host's fully qualified name */
char *get_full_hostname ();

/* Strip local domain off hostname */
char *strip_hostname ();

/* Compare two hostnames */
int same_hostname ();

/* Compare two hosts for identity by comparing their IP addresses */
int same_hostip ();

/* Get the device file name for a tty line */
char * get_device_name ();

/* Return the time that TTY was last accessed.  TTY is the name of the
   terminal device, as in "ttyp0", or "console". */
time_t get_last_access ();

/* Return a string which is the location of the terminal in utmp ENTRY. */
char *tty_location ();

/* Invalidate ttylocs. */
void reset_ttylocs ();

/* Look up a host:tty location entry */
char *tty_lookup ();

/* Strip ttyname to compact format */
char *strip_ttyname ();

#endif /* _OS_H_ */
