/*
 * face-finger.h --
 *	Routines defined in face-finger.c
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: face-finger.h,v 1.4 1992/09/03 18:40:42 stolcke Exp $ ICSI (Berkeley)
 */

#if !defined (_FACE_FINGER_H_)
#define _FACE_FINGER_H_

#include "bitmap.h"

/* Tell CONNECTION to send us the face for USER, and then display that
   face.  Returns non-zero if CONNECTION had a face for USER. */
int face_finger ();

/* Read a BITMAP * from CONNECTION.  USER is the name of the user to
   read the bits for. */
BITMAP *get_face_bits ();

#endif /* _FACE_FINGER_H_ */
