'\"
'\" Copyright (C) 1992 International Computer Science Institute, Berkeley, USA.
'\"
'\" This file is part of GNU Finger.
'\" 
'\" GNU Finger is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License as published
'\" by the Free Software Foundation; either version 1, or (at your
'\" option) any later version.
'\"
'\" GNU Finger is distributed in the hope that it will be useful, but
'\" WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'\" General Public License for more details.
'\"
'\" You should have received a copy of the GNU General Public License
'\" along with GNU Finger; see the file COPYING.  If not, write to the
'\" Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
'\"
.TH TTYLOCS 5 "$Date: 1994/10/14 22:58:06 $"
.SH NAME
ttylocs \- GNU finger tty and host locations database
.SH DESCRIPTION
The file
.B ttylocs
in the GNU finger directory (fingerdir) contains information about
physical locations of terminals and hosts.
The information it contains is used by
.BR cfingerd (8)
to determine the contents of the "Where" field in finger packets
unless the corresponding login is from a remote host.
The information is in the same format as
.BR hostconfig (5),
with lines of the form
.nf

	\fIterminal\fP	\fIlocation\fP

.fi
.I terminal
is the first word of non-whitespace characters on the line, whereas
.I location
is taken to be everything following, stripped of any leading and trailing
whitespace.
Terminal name matching is case-insensitive.
A pound sign (#) as the first non-whitespace character on the line
marks the text following as a comment that is ignored.
Empty lines are likewise ignored.
.PP
Only the first occurrence of a
.I terminal
is significant.
.PP
The
.I terminal
field
may take on several forms.
.TP 10
.I tty
The filename of a terminal device, without the leading
.B /dev/
pathname, e.g.,
.BR ttya2 .
This specifies the
.I location
of the indicated line on the local host.
.TP
.I hostname
The
.I location
serves as a default for all terminal lines on the named host.
.TP
.IB host : tty
Specifies location of terminal
.I tty
on
.IR host .
This format is convenient for sharing a single
.B ttylocs
file among several machines.
.PP
If a tty location cannot be determined from
.BR ttylocs ,
and if the host system supports the 
.BR getttyent (3)
mechanism for access to the systems terminal line database,
finger tries to obtain the comment field from that database to fill in
for the tty location.
If that fails as well, the location is left empty.
.SH FILES
.B /usr/local/etc/fingerdir/ttylocs
.PD
.SH "SEE ALSO"
gfinger(1), cfingerd(8), hostconfig(5), getttyent(3).
