'\"
'\" Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
'\"
'\" This file is part of GNU Finger.
'\" 
'\" GNU Finger is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License as published
'\" by the Free Software Foundation; either version 1, or (at your
'\" option) any later version.
'\"
'\" GNU Finger is distributed in the hope that it will be useful, but
'\" WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'\" General Public License for more details.
'\"
'\" You should have received a copy of the GNU General Public License
'\" along with GNU Finger; see the file COPYING.  If not, write to the
'\" Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
'\"
.TH GFINGER 1 "$Date: 1994/07/25 06:08:38 $"
.SH NAME
gfinger \- Local GNU finger system
.SH SYNOPSIS
.B gfinger
.RI [ options ]
.RI [ name
\&...]
.SH DESCRIPTION
This site is running a customized version of the GNU finger system, which
replaces the Berkeley
.BR finger (1)
command.
Its main advantage is that it keeps track of all machines and users on the
local network, dispensing with the need to know a particular person's
workstation name.
.PP
There are two basic usages. Without a
.I name
argument, information about all currently logged-in users is displayed.
With one or more
.I name
specified,
.B finger
displays information about people known to the system and matching those names.
The default output format is to display a one-line summary about the most
recent login(s) of people (one for each machine).
This gives enough information to quickly determine if somebody is
currently on the system and where to reach him/her (including room number
and phone extension if known).
.PP
Of course
.I name
can be of the form
.IR user @ host
to request finger information from any host on the Internet.
In this case, however, the output format will depend entirely on the
finger system running on the remote host.
(Chances are that it will be something closer to the traditional
Berkeley
.BR finger .)
Note that
.IR user @ host
should be unnecessary as long as
.I host
is another local machine and
.I user
is not the special
.B .local
name (see below).
.SH OPTIONS
A few options allow modifying the output format.
.TP 6n
.B \-info
Display full information about a user, including office location,
office and home phone numbers (if available), home directory and
login shell, mail disposition (when last read or where forwarded),
project and plan information.
.TP
.B \-face
Display a users face bitmap, if available.
The special
.B .faces
name (see below) allows you to obtain a list of all publicly listed faces.
Faces can only be displayed on Sun consoles or under the X window system.
This option applies only to the
.I name
immediately following; repeat it before each user name you want a face for.
.TP
.BI \-width\  spec
Changes the output width of the fields "Name", "What", "Host" and "Where"
in short finger output.
.I spec
is a comma-separated list of width specifiers. A width specifier
is a integer which may be preceded by `+' or `-'. Without preceeding `+'
or `-' this specifier sets the width to the given number. `+' or `-'
increments or decrements the width accordingly.  A specifier making
the width less or equal to zero supresses the field.
.TP
.B \-l
The same as
.B \-info
for backward compatibility with Berkeley
.BR finger .
.SH "SPECIAL NAMES"
Several special actions by finger can be invoked by specifying one of the
following strings for
.IR name :
.TP 10n
.B .all
Lists all logins. The same as not specifying any
.IR name .
.TP
.B .users
Lists a one-line summary about every known user's last login (even if
not currently on the system).
.TP
.B .local
Lists local logins only, i.e., only for the local machine
or the one specified by
.RI @ host .
.TP
.B .faces
Lists all available face bitmap names.
.TP
.B .free
Lists all machines deemed not to be currently in use.
Don't take this as an invitation to hog somebody else's workstation.
.TP
.B .clients
Lists the status of all machines on the network (as far as known to
.BR finger ).
.TP
.B .help
Prints a short usage summary.
.TP
.B .site
Prints site identification.
.TP
.B .version
Gives version information.
.SH "OUTSIDE FINGERS"
When the local finger system is contacted from a `non-local' host
(as defined by the system administrator),
.BR .users ,
.B .free
and
.B .clients
are disabled for security reasons.
Note that
.B \-info
and
.B \-face
on a remote system require a GNU finger installed on that system.
.SH "FACE DISPLAY"
Faces requested with the
.B \-face
option can be displayed under either X11 or SunView.
For each name a window containing the face bitmap is popped up.
Several buttons request additional action.
.TP 10
.B finger
starts an ordinary (textual) finger request to the address corresponding
to the displayed face, and shows the result in a popup window.
.TP
.B Save
dumps the bitmap to a file in the same directory the finger daemon
uses to lookup local bitmaps.
This may not be very useful for the ordinary user.
Define the environment variable MUGSHOT_PATH to use a different
directory instead.
.TP
.B Print
sends a PostScript rendering of the face to the printer.
To use a non-default printer set the environment variable PRINTER.
.TP
.B Quit
pops down the window.
.SH "CUSTOMIZING FINGER INFO"
You are encouraged to keep the information displayed by finger up-to-date
to maximize usefulness of the system.
The office and phone information displayed in the header of the long listing
can be modified using the
.BR chfn (1)
command.
On SunOS machines, 
when asked for the `Name', enter a line of items separated by commas, using the
format:
.br

.IR "real name" , "office number" , "phone extension" \c
.RI , "home phone"

.br
On Ultrix systems,
.BR chfn
prompts for each of these items separately so you don't have to worry about
the format.
.PP
To change what is displayed as your `Project' and `Plan' edit the
files
.B .project
and
.B .plan
in your home directory, respectively.
It is customary for
.B .project
to contain a one-line summary or your group or project affiliation,
and to have other useful information like mailing address and
travel plans in your
.B .plan
file.
.PP
The file
.B .face
in your home directory can be used to deposit a face bitmap in a
site-dependent format (usually as an X11 bitmap).
However, to be included in the global face listing produced by
.BR finger\ .faces 
the bitmap needs to be installed in
.BR /usr/local/images/finger .
.SH "FINGERRC SCRIPTS"
The ultimate in personalized finger response is possible through the
use of a
.B .fingerrc
file in your home directory.
This script or program, if present and executable, is expected to generate the
text you want presented in response to a `long' finger request.
The file has to be an executable owned by you, not be group or world writable,
and have no set user/group id flags.
It is executed in your home directory, as user "nobody" to prevent accidentally
giving out private information.
.PP
To make it easy to modify the default output format, the regular long
finger text is given as the script's standard input.
Also, three arguments are provided: the fingerer's host name or address,
the word
.B local
or
.B remote
depending on where the finger request
originated, and the fingerer's user name (an empty string if the name
cannot be determined).
If
.B .fingerrc
terminates with a non-zero exit status it is assumed to have failed.
The default output is generated in this case.
.SH FILES
.PD 0
.TP 28n
.B ~/.project
Project description.
.TP
.B ~/.plan
Plan description.
.TP
.B ~/.fingerrc
Personalized finger info script.
.TP
.B ~/.face
Private face bitmap.
.TP
.B /usr/ucb/finger
Original BSD finger program.
.TP
.B /usr/local/etc/fingerdir/hostconfig
Name of finger server host.
.TP
.B /usr/local/etc/fingerdir/ttylocs
List of machine and terminal locations.
.TP
.B /usr/local/etc/fingerdir/targets
Special target implementation scripts.
.TP
.B /usr/local/images/finger
Public face bitmap repository.
.PD
.SH "SEE ALSO"
chfn(1), finger(1), gfingerd(8), cfingerd(8), hostconfig(5), Emacs Info on
.IR finger .
.SH BUGS
The login information for
.B \-info
output is for the local machine only.
.PP
.B \-face
requires
.I name 
to be the login name exactly.
.PP
Berkeley finger options other than
.B \-l
are not recognized.
.PP
The
.B .fingerrc
script is executed with only a minimal environment, meaning that it has
to set up a suitable PATH and other environment variables itself if needed.
.PP
.B .fingerrc
is simply ignored on hosts where the user has no valid login shell;
arguably the request should be passed on to another machine in this case.
