#if !defined(UTL_H)
#define UTL_H TRUE
/*========================================================================
*
* Name - %M%
*
* Version:     %I%
*
* ccsid:       %W% - %G% %U%
* from:        %F%
* date:        %H% %T%
*
* %Q%
*
* Description: Miscellaneous system wide utilities
*
*========================================================================*/

/* Macro to see if edit insertion will fit */
#define CHECK_INSERT(n) (strlen(TheEditData.current_buffer) + (n) \
  <= MAX_CMD_LINE_LENGTH)

#define CLEAR_FACTOR {TheEditData.factor = 1;}

#define SAY_BOOL(x) sayBool((BoolType)(x))

#define ZERO_EDIT_LINE { \
  TheEditData.dot = &TheEditData.current_buffer[0]; \
  TheEditData.mark = TheEditData.dot; \
  *TheEditData.dot = '\0'; \
  CLEAR_FACTOR; \
  }

/* Panic exit Routine */
int abortit();

/* Routines to preform insertion and deletion on the edit buffer, fixing
  up marks: */
void edit_insert();
void edit_remove();

double getLoadAverage();
int get_line_char();
int getTty();
int myabspath(); /* returns 0 on success */
void quietly_run_program_connected_to_standard_tty();
int run_program_connected_to_standard_tty();

char *sayBool(); /* translate bool to char * */
int setTty();

#endif
