#define UTL_C TRUE
/*========================================================================
 *
 * Name - %M%
 *
 * Version:    %I%
 *
 * ccsid:      %W% - %G% %U%
 * from:       %F%
 * date:       %H% %T%
 *
 * %Q%
 *
 * Description: Miscellaneous utilities
 *
 *========================================================================
*/
#include <stdio.h>
#include <ctype.h>

#include "rkglobal.h"
#include "rk.h"
#include "display.h"
#include "kbdbind.h"
#include "system.h"
#include "kbdsys.h"

#include "utl.h"

/* =======================================================================
 * Name - abortit
 *
 * Purpose - General Purpose Exit Handler
 *
 * Arguments:  message -- message to print, possibly zero-length
 *             status -- status to return to pUnix
 *
 * Returns     There is no return!!!
 *
 *========================================================================
 */
int abortit (message, status)
char *message;
int status;
{
#if 0
/* Was:  shutdown_();
 * Purpose - vestigial -- some attempt to put end of session mark in
 *   the log file?  Doesn't work worth a hoot --- DJP
 */
{
FILE *to;

if ((to = fopen (log_file, "a")) != NULL) {
  fputs ("\07", to);
  fflush (to);
  fclose(to);
  }
}
#endif

erase_pred_buffer();
close(pty_master);
kbd_canonical(KEYBOARD);
if (message[0] != '\0')
  fprintf(stderr, "%s: %s\r\n", ProgramName, message);
else
  fprintf(stderr, "\r\n");
fflush(stdout);
fflush(stderr);
exit(status);
}

/* =======================================================================
 * Name - edit_insert
 *
 * Purpose - Insert s into edit data at current dot.  Adjst marks appropriately
 *
 *  Caller is assumed to have checked that insertion will fit (see
 *     CHECK_INSERT).
 *
 * Arguments:  s -- string to insert at TheEditData.dot
 *             n -- number of characters to insert from s.
 *
 * Returns     function return --
 *
 *========================================================================
 */
void edit_insert(s, n)
char s[];
int n;
{
EditStrType junkStr;
int junkLen;

strcpy(junkStr, TheEditData.dot);
junkLen = strlen(TheEditData.dot);
memcpy(TheEditData.dot, s, n);
memcpy(&TheEditData.dot[n], junkStr, junkLen);
TheEditData.dot[n + junkLen] = '\0';
if (TheEditData.mark > TheEditData.dot) /* adjust mark */
  TheEditData.mark += n;
}

/* =======================================================================
 * Name - edit_remove
 *
 * Purpose - Remove n characters from edit data at current dot.  Adjust
 *           marks appropriately.
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
void edit_remove(n)
{
EditStrType junkStr;

strcpy(junkStr, &TheEditData.dot[n]);
strcpy(TheEditData.dot, junkStr);
if (TheEditData.mark <= TheEditData.dot)
  return;
if (TheEditData.mark >= &TheEditData.dot[n]) {
  /* move mark over appropriately */
  TheEditData.mark -= n;
  return;
  }
/* Mark was in deleted area -- set to dot */
TheEditData.mark = TheEditData.dot;
}

/* =======================================================================
 * Name - getLoadAverage
 *
 * Purpose -
 *
 * Arguments:
 *
 * Returns     function return -- load average, from "uptime"
 *
 *========================================================================
 */
double getLoadAverage()
{
FILE *from;
char *b;
EditStrType tbuf;

/* calc amount to prime, sys load dependent*/
#if defined(FLG_AIX_UNIX) /* no "uptime" in AIX */
  return 1.0;
#else
if ((from = popen("uptime", "r")) != NULL) {
  fgets(tbuf, MAX_CMD_LINE_LENGTH, from);
  b = rindex(tbuf, ':');
  b++;
  pclose(from);
  return atof(b);
  }
else
  return 1.0;
#endif
}

#if defined(FLG_HPUX_UNIX)
char *getwd(buf)
EditStrType buf;
{
return getcwd(buf, MAX_CMD_LINE_LENGTH);
}
#endif

/* =======================================================================
 * Name - myabspath
 *
 * Purpose - Translate a not-quite literal directory path
 *
 * Arguments:  path -- path to translate
 *
 * Returns     function return -- 0 on success
 *                       buff -- fully translated path
 *
 * This is primarily to translate names of the form, ~/foo, or
 * ~aluser, but in the future it might handle $envname/bar as well.
 *========================================================================
 */
/* Mark James 89/5/24*/
int myabspath(path,buff)
EditStrType path;
EditStrType buff;
{
char *homedir;
char *cptr = &path[0];
EditStrType username;
int i;
struct passwd *pwd;

/* Skip space */
while (isspace(*cptr) && *cptr != '\0')
  cptr++;

/* Do we have a tilde? */
if (*cptr == '~') {
  cptr++;                              /* skip it */
  if (*cptr == '/' || *cptr == '\0') { /* home directory */
    if ((pwd = getpwuid((int)getuid())) == NULL) {
      if ((homedir = getenv("HOME")) == NULL)
       return 1;
      strcpy(buff, homedir);
      strcat(buff, cptr);
      return 0;
      }
    strcpy(buff, pwd->pw_dir);
    strcat(buff, cptr);
    return 0;
    }

/* Not home directory */
  for (i = 0; *cptr != '/' && *cptr != '\0'; i++, cptr++)
    username[i] = *cptr;
  username[i] = '\0';
  if ((pwd = getpwnam(username)) == NULL)
    return 1;
  strcpy(buff, pwd->pw_dir);
  strcat(buff, cptr);
  return 0;
  }

if (*cptr == '$') { /* $envname/path/file */
  char *firstSlash;
  char *envPtr;
  EditStrType envname;
  int  len;

  if ((firstSlash = index(cptr, '/')) != NULL) {
    len = firstSlash - cptr - 1;
    (void)strncpy(envname, cptr + 1, len);
    envname[len] = '\0';

    if ( (envPtr = (char *)getenv(envname)) != NULL) {
      (void)strcpy(buff, envPtr);
      (void)strcat(buff, firstSlash);
      return 0; /* done */
      }
    }
  else { /* only an environment variable */
    strcpy(envname, cptr + 1);
    if ( (envPtr = getenv(envname)) != NULL) {
      (void)strcpy(buff, envPtr);
      return 0; /* done */
      }
    }
  }

/* If we get here, this is assumed to be an absolute filename. */
strcpy(buff, cptr);
return 0;
}

#if defined(FLG_AIX_UNIX) || defined(FLG_HPUX_UNIX)
int psignal(sig, s)
unsigned sig;
char *s;
{
fprintf(stderr, "%s: Signal %d\n", s, sig);
fflush(stderr);
}
#endif

/* =======================================================================
 * Name - quietly_run_program_connected_to_standard_tty
 *
 * Purpose -
 *
 * Arguments:
 *
 * Returns     function return -- Keyboard status
 *
 *========================================================================
 */
void quietly_run_program_connected_to_standard_tty(cmd)
char           *cmd;
{
UnixSignalFuncType *sig;

kbd_canonical(KEYBOARD);
sig=signal(SIGCHLD, (UnixSignalFuncType *)SIG_DFL);
system(cmd);
signal(SIGCHLD, sig);
kbd_raw(KEYBOARD);
}

/* =======================================================================
 * Name - run_program_connected_to_standard_tty
 *
 * Purpose -
 *
 * Arguments:
 *
 * Returns     function return -- Keyboard status
 *
 *========================================================================
 */
int run_program_connected_to_standard_tty(cmd)
char           *cmd;
{
int             status;
UnixSignalFuncType *sig;

erase_current_edit_line();
kbd_canonical(KEYBOARD);
printf("%s:  Now running \"%s\"\r\n", ProgramName, cmd);
sig=signal(SIGCHLD, (UnixSignalFuncType *)SIG_DFL);
status = system(cmd);
signal(SIGCHLD, sig);
printf("%s:  Finished running \"%s\"\r\n", ProgramName, cmd);
kbd_raw(KEYBOARD);
display_continue();
CLEAR_FACTOR;
return status;
}


/* =======================================================================
 * Name - sayBool
 *
 * Purpose - Translate Boolean to char *
 *
 * Arguments:  x -- the boolean
 *
 * Returns     function return -- Address of either "TRUE" or "FALSE"
 *
 *========================================================================
 */
char *sayBool(x)
BoolType x;
{
if (x)
  return "TRUE";
return "FALSE";
}
