#if !defined(SYSTEM_H)
#define SYSTEM_H TRUE
/*========================================================================
*
* Name - %M%
*
* Version:     %I%
*
* ccsid:       %W% - %G% %U%
* from:        %F%
* date:        %H% %T%
*
* %Q%
*
* Description: Types and interfaces to OS and run-time library
*
*========================================================================*/

#if defined(AIX)
#define FLG_AIX_UNIX TRUE
#endif

#if defined(sun)
#define FLG_SUN_UNIX TRUE
#if defined(mc68020)
#define sun3 TRUE
#endif
#if defined(sparc)
#define sun4 TRUE
#endif
#if defined(sun386)
/* #define sun_roadrunner TRUE */
#endif
#endif

#if defined(ultrix)
#define FLG_ULTRIX_UNIX TRUE
#endif

#if defined(sony_news)
#define FLG_NEWS_UNIX TRUE
#endif

#if defined(hpux)
#define FLG_HPUX_UNIX TRUE
#define _TERMIOS_INCLUDED TRUE
#endif

/* LINTLIBRARY */
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <sys/file.h>
#include <sys/resource.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <pwd.h>
#include <strings.h>

#if defined(FLG_AIX_UNIX)
#include <sys/termio.h>
#include <sys/pty.h>
#include <dirent.h>

#define SIGCHLD SIGCLD
#define X_OK   1 /* executable by caller */
#define W_OK   2 /* writable by caller */
#define R_OK   4 /* readable by caller */
#endif

#if !defined(FLG_AIX_UNIX) && !defined(FLG_HPUX_UNIX)
#include <sys/dir.h>

struct direct *readdir();
#endif

#if defined(FLG_HPUX_UNIX)
#include <sys/termio.h>
#include <dirent.h>

#define index(x, y) strchr(x, y)
#define rindex(x, y) strrchr(x, y)
#define getdtablesize() FD_SETSIZE
#endif

/**********************************************************
   Various System Declarations Missing on Many Systems...
***********************************************************/

double atof();

#if defined(FLG_HPUX_UNIX)
char *getcwd();
#else
char *getwd();
#endif

char *getenv();
struct passwd *getpwuid();
struct passwd *getpwnam();
char *gets();
uid_t getuid();

#if !defined(FLG_HPUX_UNIX)
char *index();
#endif

char *malloc();
char *memcpy();
char *memset();
DIR  *opendir();
FILE *popen();
int psignal();

#if !defined(FLG_HPUX_UNIX)
char *rindex();
#endif

#if defined(FLG_HPUX_UNIX)
int sprintf();
#else
char *sprintf();
#endif

char *strcat();

#if defined(FLG_HPUX_UNIX)
char *strchr();
#endif

int strncmp();
char *strcpy();

#if defined(FLG_HPUX_UNIX)
char *strrchr();
#endif

char *tgoto();
char *tgetstr();

#if defined(FLG_SUN_UNIX) /* size_t and malloc() defined inconsistently */
#define MALLOC(x) malloc((unsigned)(x))
#else
#define MALLOC(x) malloc((size_t)(x))
#endif

#define FREE(x)   free((char *)(x))

#if defined(FLG_AIX_UNIX)
typedef struct termio TermInfoSType;
typedef struct dirent SysDirectSType;
#else
#if defined(FLG_HPUX_UNIX)
typedef struct termios TermInfoSType;
typedef struct dirent SysDirectSType;
#else /* BSD */
typedef struct sgttyb TermInfoSType;
typedef struct direct SysDirectSType;
#endif
#endif

#if defined(FLG_AIX_UNIX) || defined(sony_news)
typedef int UnixSignalFuncType();
#else /* ultrix, hp-ux, sunos */
typedef void UnixSignalFuncType();
#endif

UnixSignalFuncType *signal();

extern int errno;

#if !defined(FLG_HPUX_UNIX)
extern char *sys_siglist[];
#endif

#endif
