/************************************************************************
 *									*
 *	SETUP - utility program for changing rk setings.		*
 *	New values for rk global variables are saved in			*
 *	~/.rk.defaults file and can be used by calling:			*
 *		rk -d							*
 *									*
 *	Modified to run okay from within rk--hence odd sleeps, etc.     *
 ************************************************************************/

#define RK_C TRUE
#define LINE_NUM   22
#define FB         12      /* 12 -- Line for starting Bool type */
#define FI          4      /*  4 -- Line for starting integer   */

#include <sys/file.h>
#include "rkglobal.h"
#include "rk.h"
#include "defaults.h"
#include <stdio.h>
#include <sys/ioctl.h>
#include <sgtty.h>

extern int errno;

/*****	terminal characteristics	*****/

char * start, * stop, * home, * ctoend;
char * cupn, * cdwn, * ctolin, * cule;

/*****	rk global's types (0-Bool, 1-int, 2-*char)	*****/

            /* line number: 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 */
char data_prof[LINE_NUM] = {2,2,2,7,1,1,1,1,1,1,1,7,0,0,0,0,0,0,0,0,0,0};

/*****	current line number		*****/

int  curr_line=50;

struct sgttyb new_stdin, old_stdin;
char tipp=5;
char modif=0;

main()
{
	read_file();
	get_termcap_stuff();
	do_tty_stuff();
	print_header();
	go_to_line(1);
	change();
	exit(0);
}

/*****	read 1 character from stdin	*****/

READ(charp)
char * charp;
{
	read(0, charp, 1);
	*charp &= 127;
}

/*****	get terminal characteristics from /etc/termcap file	*****/

get_termcap_stuff()
{
	static char * tgetstr(), * area, tpom[1024], *tername;
	static char * getenv(), tkom[1024];

	tername=getenv("TERM");
	area = tpom;
	tgetent(tkom, tername);
	start = tgetstr("so", &area);
	stop  = tgetstr("se", &area);
	home  = tgetstr("ho", &area);
	ctoend= tgetstr("cd", &area);
	ctolin= tgetstr("ce", &area);
	cupn  = tgetstr("up", &area);
	cdwn  = tgetstr("do", &area);
	cule="\010\0";
	if(! tgetflag("bs"))
		cule  = tgetstr("bc", &area);

}

/*****	setup terminal characteristic for raw I/O	*****/

do_tty_stuff()
{
  ioctl(0,TIOCGETP,&old_stdin);
  ioctl(0,TIOCGETP,&new_stdin);
  new_stdin.sg_flags|=(CBREAK|RAW|CRMOD);
  new_stdin.sg_flags&=~(ECHO);
  ioctl(0,TIOCSETP,&new_stdin);
  sleep(1);
}

/*****	prints text on screen		*****/

print_header()
{
	printf("%s%s", home, ctoend);


        printf("\rFilenames arguments (valid values= any Unix file name <CR>):");

	printf("\r\n\t-p <prime file>\t\t\t%s %s %s",
		 start, prime_file, stop);
	printf("\r\n\t-q <(quaint) log file>\t\t%s %s %s",
		 start, log_file, stop);
	printf("\r\n\t-z <zero frequency file>\t%s %s %s",
		 start, zero_freq_file, stop);


	printf("\r\nNumeric arguments (valid values= integers <CR>):");

	printf("\r\n\t-b buffers to save\t\t%s %d %s",
		 start, num_buffers, stop);
	printf("\r\n\t-e end of line length\t\t%s %d %s",
		 start, max_eol, stop);
	printf("\r\n\t-f frequency count maximum\t%s %d %s",
		 start, max_freq, stop);
	printf("\r\n\t-i inline length\t\t%s %d %s",
		 start, max_len, stop);
	printf("\r\n\t-m memory maximum\t\t%s %d %s",
		 start, mem_limit, stop);
	printf("\r\n\t-n number of prime characters\t%s %d %s",
		 start, maxprime, stop);
	printf("\r\n\t-o order of model\t\t%s %d %s",
		 start, maxk, stop);


	printf("\r\nUpper & lower-case toggles_ (valid values= 0 or 1) use ^C:");

	printf("\r\n\t-E (eol_longer_mode)\t\t%s %d %s",
		 start, eol_longer_mode, stop);
	printf("\r\n\t-L (lisp_mode)\t\t\t%s %d %s",
		 start, lisp_mode, stop);
	printf("\r\n\t-N (nl_truncate_mode)\t\t%s %d %s",
		 start, nl_truncate_mode, stop);
	printf("\r\n\t-O (only_at_eol_mode)\t\t%s %d %s",
		 start, eol_only_mode, stop);
	printf("\r\n\t-P (prediction_mode)\t\t%s %d %s",
		 start, pred_mode, stop);
	printf("\r\n\t-S (show_eol_mode)\t\t%s %d %s",
		 start, show_eol_mode, stop);

	printf("\r\n\t-l Login shell\t\t\t%s %d %s",
		 start, login, stop);
	printf("\r\n\t-s Silent startup\t\t%s %d %s",
		 start, silent, stop);
	printf("\r\n\t-u Underline\t\t\t%s %d %s",
		 start, underlineMode, stop);
	printf("\r\n\t-8 8-bit mode\t\t\t%s %d %s",
		 start, eight_bit_mode, stop);

	printf("\r\n\t\t\t\t\t");

	curr_line = LINE_NUM+1;
}

/*****	go to line number i and print message (if needed)	*****/

go_to_line(i)
int i;
{
    int k, ip;
    char * pom, sgn();	

    if(i > LINE_NUM) i=1;
    if(i <  1) i=LINE_NUM;

    if(i == curr_line)return;

    if(tipp == sgn(data_prof[i-1])){
	if(i>curr_line) for(k=curr_line; k<i; k++) printf("%s", cdwn);
	else for(k=i; k<curr_line; k++) printf("%s", cupn);
	fflush(stdout);
	}
    else {
	if(data_prof[i-1] == 7){
		if(curr_line < i) i+=1;
		else i -=1;
	}
	for(k = curr_line; k<LINE_NUM+1; k++) printf("%s", cdwn); /* was +4 */
	printf("\n\rEnter: ^Q(uit), ^S(ave), ^R(eset), ^U(p), ^D(own) or ");

	switch(data_prof[i-1]){

	case 0: printf("^C(hange)        ");
		tipp=0;
		break;

	case 1:
	case 2: printf("enter new value");
		tipp=1;
		break;

	default: break;
	}

	printf("\n\r\t\t\t\t\t");

	for(k=i; k<LINE_NUM+3; k++) printf("%s", cupn);  /* was +6 */
	fflush(stdout);
	}

	curr_line=i;
}

char sgn(c)
char c;
{

	switch(c){
		case 1:
		case 2: return(1);
			break;
		case 0: return(0);
			break;
		case 7: return(-1);
			break;
	}
}

/*****	main loop for user actions	*****/

change()
{
  char ch, *pom, ppom[30];
  static char zero_freq_buf[50], log_buf[50], prime_buf[50];
  int nbytes, ip, iv;

  while((nbytes=read(0,&ch,1))!=-1){
     ch &= 127;

	switch(ch) {
					/* one line up */
	case 21: go_to_line(curr_line-1);
		break;
					/* one line down */
	case 4: go_to_line(curr_line+1);
		break;
					/* quit program */
	case 17: for(ip=curr_line; ip<LINE_NUM+1; ip++) printf("%s", cdwn);
		 printf("\n\r");       /* was +7 */
		 if(modif){
printf("                                                                  \r");
printf("Do you wish to save new values (y/n)?  ");
			fflush(stdout);
			READ(&ch);
			if((ch == 'y') || (ch == 'Y')) {
			   savef();
			   printf("\n\rNew values saved in ~/.rk.defaults");
			}
		 }
	 	 printf("\r\n");
		 fflush(stdout);
		 fflush(stderr);
		 sleep(2);
		 ioctl(0, TIOCSETP, &old_stdin);
		 return;
		 break;
				/* Reset */
	case 18: read_file();
		 modif=0;
		 tipp=5;
		 ioctl(0, TIOCSETP, &old_stdin);
		 print_header();
		 ioctl(0, TIOCSETP, &new_stdin);
		 go_to_line(1);
		 break;
					/* save to file */
	case 19: savef();
		 modif=0;
/*was +2*/	 for(iv=curr_line; iv<LINE_NUM+1; iv++)printf("%s",cdwn);
printf("\n\rSaved in file: ~/.rk.defaults                                  \r");
		 fflush(stdout);
/**/
		 sleep(4);
	 	 printf("\rEnter: ^Q(uit), ^S(ave), ^R(eset), ^U(p), ^D(own) or ");

 		 switch(data_prof[curr_line]){

			case 0: printf("^C(hange)        ");
				tipp=0;
				break;

			case 1:
			case 2: printf("enter new value");
				tipp=1;
				break;

			default: break;
			}
/**/
		 printf("\n\r\t\t\t\t\t");
		 fflush(stdout);
/*was +3*/	 for(iv=curr_line; iv<LINE_NUM+2+1; iv++)printf("%s",cupn);
		 fflush(stdout);
		 break;
					/* change Bool value */
	case 3: changev();
		modif=1;
		break;

	case 13: 
		if(data_prof[curr_line-1] == 2) {
			modif=1;
			switch(curr_line){
			
			case 1: prime_file=0;
				break;
			case 2: log_file=0;
				break;
			case 3: zero_freq_file=0;
				break;
			}
			pom=0;
			printf("%s%s%s %s %s",ctolin,cule,start,pom,stop);
			for(iv=0; iv<8; iv++) printf("%s",cule);
			fflush(stdout);
			}
		go_to_line(curr_line+1);
		break;

	default: {
	   if(data_prof[curr_line-1] == 0) break;
	   if(data_prof[curr_line-1] == 2) {
		if(ch < 33)break;
		modif=1;
		putchar(' ');
		putchar(ch);
		fflush(stdout);
		ip=1;
		ppom[0]=ch;
		READ(&ch);
		while(ch != 13){
			putchar(ch);
			fflush(stdout);
			ppom[ip++]=ch;
			READ(&ch);
		}
		ppom[ip]=0;
		pom=ppom;
		for(iv=0; iv<=ip; iv++) printf("%s", cule);
		fflush(stdout);
		printf("%s%s%s %s %s", ctolin, cule, start, pom, stop);
		fflush(stdout);

		switch(curr_line){

		case 1: prime_file=prime_buf;
			strcpy(prime_file,pom);
			break;
		case 2: log_file=log_buf;
			strcpy(log_file,pom);
			break;
		case 3: zero_freq_file=zero_freq_buf;
			strcpy(zero_freq_file, pom);
			break;
		}
	   }
	  else{
				/* input new values for integer variables */
		if((ch<'0')||(ch>'9')) break;
		modif=1;
		putchar(' ');
		putchar(ch);
		fflush(stdout);
		ppom[0]=ch;
		ip=1;
		READ(&ch);
		while((ch>='0') && (ch <= '9')){
			putchar(ch);
			fflush(stdout);
			ppom[ip++]=ch;
			READ(&ch);
		}
		ppom[ip]=0;
		pom=ppom;
		for(iv=0; iv<=ip; iv++)printf("%s",cule);
		fflush(stdout);
		printf("%s%s%s %s %s", ctolin, cule, start, pom, stop);
		fflush(stdout);
		ip=sscanf(pom, "%d", &iv);
		switch(curr_line){
		
		case FI+1 : num_buffers = iv;
			 break;
		case FI+2 : max_eol = iv;
			 break;
		case FI+3 : max_freq = iv;
			 break;
		case FI+4 : max_len = iv;
			break;
		case FI+5 : mem_limit = iv;
			 break;
		case FI+6 : maxprime = iv;
			 break;
		case FI+7 : maxk = iv;
			 break;
		}
	   }
	tipp=5;
	go_to_line(curr_line+1);

		
	}}
     }
}

/*****	change values for Bool type variables	*****/

changev()
{
	int ipom;

	if(data_prof[curr_line-1] != 0) return;

	switch(curr_line){
	
	case  FB+1 : eol_longer_mode =! eol_longer_mode;
		 ipom= eol_longer_mode;
		 break;

	case  FB+2 : lisp_mode =! lisp_mode;
		 ipom= lisp_mode;
		 break;

	case  FB+3 : nl_truncate_mode =! nl_truncate_mode;
		 ipom= nl_truncate_mode;
		 break;

	case  FB+4 : eol_only_mode = !  eol_only_mode;
		 ipom= eol_only_mode;
		 break;

	case  FB+5 : pred_mode =! pred_mode;
		 ipom= pred_mode;
		 break;

	case FB+6 : show_eol_mode =! show_eol_mode;
		 ipom= show_eol_mode;
		 break;


	case  FB+7 : login =! login;
		 ipom= login;
		 break;

	case FB+8 : silent =! silent;
		 ipom= silent;
		 break;

	case FB+9 : underlineMode =! underlineMode;
		 ipom= underlineMode;
		 break;

	case FB+10 : eight_bit_mode =! eight_bit_mode;
		 ipom= eight_bit_mode;
		 break;
	}

	printf("%s %d %s%s%s%s", start, ipom, stop,cule,cule,cule);
	go_to_line(curr_line+1);
}

/*****	save values to file ~/.rk.defaults	*****/

savef()
{
	FILE * to, * fopen();
	char * getenv(), *pom, tpom[50], *kom;

	pom=tpom;

	kom=getenv("HOME");
	strcpy(pom, kom);
	strcat(pom,"/.rk.defaults");
	to=fopen(pom,"w");
	if(to== NULL) {
printf("\n\rrk: unable to open .rk.defaults.  Have you run \"setup\" yet?\n\r");
		exit(0);
	}

	if(zero_freq_file == 0) fprintf(to, " %d", 0);
	else fprintf(to, " %d %s", strlen(zero_freq_file), zero_freq_file);

	if(log_file == 0) fprintf(to, " %d", 0);
	else fprintf(to, " %d %s", strlen(log_file), log_file);

	if(prime_file == 0) fprintf(to," %d", 0);
	else fprintf(to," %d %s", strlen(prime_file), prime_file);

	fprintf(to, 
		" %c %c %c %c %c %c %c %c %c %c %d %d %d %d %d %d %ld",
		eol_longer_mode,
		eol_only_mode,
		lisp_mode,
		login,
		nl_truncate_mode,
		pred_mode,
		show_eol_mode,
		silent,
		underlineMode,
		eight_bit_mode,
		max_eol,
		max_freq,
		maxk,
		max_len,
		maxprime,
		num_buffers,
		mem_limit);
	fflush(to);
	fclose(to);
}

/*****	read values from file ~/.rk.defaults	*****/

read_file()
{
	FILE * to, * fopen();
	char * getenv(), *pom, ppom[50], * kom;
	static char zero_freq_buf[50], log_buf[50], prime_buf[50];
	int lzff, llf, lpf;

	zero_freq_file= log_file= prime_file = 0;
	pom=ppom;

	kom=getenv("HOME");
	strcpy(pom, kom);
	strcat(pom,"/.rk.defaults");
        if(access(pom,4)==-1)return;	
        to=fopen(pom,"r+");
	if(to== NULL) {
printf("\r\nrk: unable to open .rk.defaults.  Have you run \"setup\" yet?\r\n");
		exit(0);
	}

	fscanf(to,"%d", & lzff);
	if(lzff > 0) {
		zero_freq_file=zero_freq_buf;
		fscanf(to,"%s", zero_freq_file);
	}
	fscanf(to,"%d", & llf);
	if(llf  > 0) {
		log_file=log_buf;
		fscanf(to,"%s", log_file);
	}
	fscanf(to,"%d", & lpf);
	if(lpf  > 0) {
		prime_file=prime_buf;
		fscanf(to,"%s", prime_file);
	}

	fscanf(to, 
		" %c %c %c %c %c %c %c %c %c %c %d%d%d%d%d%d%ld",
		& eol_longer_mode,
		& eol_only_mode,
		& lisp_mode,
		& login,
		& nl_truncate_mode,
		& pred_mode,
		& show_eol_mode,
		& silent,
		& underlineMode,
		& eight_bit_mode,
		& max_eol,
		& max_freq,
		& maxk,
		& max_len,
		& maxprime,
		& num_buffers,
		& mem_limit);
	fflush(to);
	fclose(to);
}
