#if !defined(RKGLOBAL_H)
#define RKGLOBAL_H TRUE
/*========================================================================
*
* Name - %M%
*
* Version:     %I%
*
* ccsid:       %W% - %G% %U%
* from:        %F%
* date:        %H% %T%
*
* %Q%
*
* Description: Types and constants shared throughout RK
*
*========================================================================*/

#if defined(AIX)
#define BSD_INCLUDES
#define SIGCHLD SIGCLD
#endif

#include <sys/param.h>     /* JJD 3-89 added to get MAXPATHLEN and CANBSIZ */
#include <sys/ioctl.h>


typedef unsigned char BoolType;
#if !defined(FALSE)
#define FALSE 0
#define TRUE 1
#endif

#define OK                0
#define FINISHED_EDITING -1
#define FINISHED_BUT_DONT_ADD_CTRL_M -2
#define HAVE_CHAR -3

#define MAX_SET                128       /* max # of different symbols (ASCII) */

#define MAX_CMD_LINE_LENGTH MAXPATHLEN /* must allow host filenames to fit */
/* Some debate over that, actually -- should it be MAXPATHLEN or
    (MAXPATHLEN + MAXNAMLEN)?  I opt for the former, obviously.  --DJP */

#define RK_VERSION "1.6c, Oct 28, 1990.  Ftp version.  This is freeware."
#define ASCII_RUBOUT 127

#define KEYBOARD 0
#define DISPLAY 1

typedef char EditStrType[MAX_CMD_LINE_LENGTH + 1];

typedef struct _ed_chunk {
    EditStrType string;
    char *dot;
    char *mark;
    struct _ed_chunk *next_ptr;
    struct _ed_chunk *prev_ptr;
    } EditChunkSType;

typedef struct {
    char current_input_char; /* current character input */
    int  factor;             /* generalized repeater facility */
    char *current_buffer;    /* current buffer */
    char *dot;               /* current point before which insertions occur */
    char *mark;              /* marked place in buffer */
    EditStrType kill_buffer; /* one piece of deleted text */
    EditChunkSType *current_ed_buff_ptr; /* current buffer being edited */
    } EditSType;

#endif
