#define REACTIVE_C TRUE
/*========================================================================
 *
 * Name - %M%
 *
 * Version:    %I%
 *
 * ccsid:      %W% - %G% %U%
 * from:       %F%
 * date:       %H% %T%
 *
 * %Q%
 *
 * Description: RK Predictive Magic
 *
 *========================================================================
 */

#include <ctype.h>
#include <stdio.h>

#include "rkglobal.h"
#include "rk.h"
#include "defaults.h"
#include "system.h"
#include "reactive.h"
#include "display.h"
#include "utl.h"
#include "kbdbind.h"
#include "kbdsys.h"


typedef struct node {                /** variable length Markov tree node **/
        char           value;        /*  ASCII symbol value (to MAX_SET-1) */
        FrequencyType  count;        /*  frequency count (to max_freq)     */
        struct node    *next;        /*  alternative predictions at this k */
        struct node    *up;          /*  next k level up, eg 3 points to 4 */
} NodeSType;

typedef NodeSType *NodeListAType[TOP_K + 1];/* k ptrs into the the k contexts*/

typedef char ContextStrType[TOP_K + MAX_CMD_LINE_LENGTH + 1];

/* NODE_ALLOCATION is the chunk size we use when allocating from system memory.
  It's set quite large (1/4 MByte to make the speed of malloc() negligible... */
#define NODE_ALLOCATION (262144 / sizeof(NodeSType))

             /* zero freqs, maybe overwritten */
static char zero_freq[MAX_SET] = {       /* by a user supplied $home/file */
  '\n',   ' ',   'e',   's',   't',   'r',   'a',   'l',
   'n',   '.',   'c',   'i',   'm',   'o',   'd',   'h',
   'p',   'u',   'f',   'b',   'w',   'g',   '-',   'y',
   '/',   'v',   'k',   '*',   'x',   '5',   '1',   '2',
   '4',   '>',   'q', '\07',   '3',   'z',   '0',   'j',
   'M',   'I',   '6',  '\'',   'E',   '~',   'A',   ',',
   'S',   'D',   'R',   '?',   'C',   '|',   'B',   'T',
   'P',   'U',   '!',   '_',   '<',   'N',   '8',   '@',
   '&',   '7',  '\\',   '"',   'J',   ')',   '(',   '[',
   ']',   'F',   'L',   ':',   'O',   'K',   '9',   'H',
   '+',   '$',   'W',   'Y',   '=',   'G',   ';',   '^',
   '{',   'X',   'Q',   '#',   '}',   'V',   '%',   'Z',
   '`',  '\b',  '\t', '\26', '\00', '\01', '\02', '\03',
 '\04', '\05', '\06', '\13',  '\f',  '\r', '\16', '\17',
 '\20', '\21', '\22', '\23', '\24', '\25', '\27', '\30',
 '\31', '\32', '\33', '\34', '\35', '\36', '\37','\177',};

static NodeListAType Buf;      /* ptrs into the model k levels  */
static NodeListAType CBuf;     /* ptrs into the model k levels  */
static ContextStrType context = "\12"; /* last chars entered */
static ContextStrType old_context = "\12";
static char   first[MAX_SET];       /* the first letter of each pred */
static char    pred_set[MAX_SET];    /* flags chars already in first[]*/
static NodeSType * free_nodes;       /* now use malloc to get at init */
static NodeSType * root;         /* the root of the k model tree  */
static long   psize;             /* # chars to prime from prime_file*/
static int    next_free;         /* index of next free node avail */
static long AllocationCount = 0;   /* for statistics */
static long CharsInModel = 0;      /* also for statistics */
static long FrequencySplits = 0;   /* ditto */
static BoolType memoryIsFull = FALSE;
static int pred_number = 0;
static long node_limit;


static int build_menu();
static NodeSType *create_node();
static char    first_pred();
static void move_up();
static void scan_up();


/* =======================================================================
 * Name - build_menu
 *
 * Purpose - Fill out prediction in pred_buff
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
static int build_menu(buf)
NodeListAType buf;
{ /* fill out prediction in s */
int i, length;
NodeListAType tbuf;
char *bptr = &pred_buff[0];
char c;

#if 0
/* following seems to be attempt to keep RK from getting too enthusiastic
   near the end of the line... */
if (eol_longer_mode && *(TheEditData.dot) == '\0') {
  length = max_eol - get_display_length(TheEditData.current_buffer);
  if (length < max_len)
    length = max_len;
  }
else
  length = max_len;
#endif

if(wrap_mode){
/* Set length of prediction, with heuristic to discourage line wrap */
length = max_len;
if (eol_longer_mode && *(TheEditData.dot) == '\0') {
  int charsLeft = (CurrentCursor + USED_COLUMNS - 1)
      / USED_COLUMNS * USED_COLUMNS  - CurrentCursor - 1;
    /* -1 for probable ^J on display length of prediction */

  if (charsLeft <= 0) /* boundary for empty prompt */
    charsLeft = USED_COLUMNS;
  if (charsLeft > max_eol)
    length = max_eol;
  else
  if (charsLeft > max_len)
    length = charsLeft;
  }
}
else {
/*** change March 1990 Dejan M. - suppress to never prediction wrap ****/

length=max_len;
if(eol_longer_mode && *(TheEditData.dot) == '\0') {
	int ipom = 1 + CurrentCursor/USED_COLUMNS;
	length = ipom * USED_COLUMNS - CurrentCursor -1;
	if(show_eol_mode) length --;
	if(length > max_eol) length = max_eol;
}
}

c = first[pred_number];
for (i = 0; i <= maxk; i++)
  tbuf[i] = buf[i];
for (i = 1; i <= length; i++) {
  if (show_eol_mode)
    *bptr++ = c;
  else
  if (c != '\n' || i == 1)
    *bptr++ = c;
  if (nl_truncate_mode && c == '\n')
    break;
  scan_up(tbuf, c);
  c = first_pred(tbuf);
  }

*bptr = '\0';
}

/* =======================================================================
 * Name - create_node
 *
 * Purpose - Allocate new node, using our shortcut heap if possible
 *
 * Arguments:
 *
 * Returns     function return -- new node
 *
 *========================================================================
 */
static NodeSType * create_node()
{         /* return ptr to a new node or abort */

AllocationCount ++;
if (AllocationCount > node_limit) {
  AllocationCount --;  /* don't lie to show_used_nodes */
  memoryIsFull = TRUE;
  return NULL;
  }
if (next_free >= NODE_ALLOCATION) {
  free_nodes = (NodeSType *)MALLOC(NODE_ALLOCATION * sizeof(NodeSType));
  if (free_nodes == NULL) {
#if 0
    abortit ("Out of memory in create_node", -1);
#endif
    /* This is really too late, as it will screw up file_completion,
       command_completion, and who knows what else.  But they can
       always use -n to keep from getting here... */
    memoryIsFull = TRUE;
    return NULL;
    }
  next_free = 0;
  }
return &free_nodes[next_free++];
}

/* =======================================================================
 * Name - find_first
 *
 * Purpose - find 1st char of all pred in context
 *           [Calculate probabilities for each possible character]
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
int find_first(buf)
NodeListAType buf;
{
int i, order = 0; NodeSType * xptr; char *p;

for (p = &pred_set[0]; p < &pred_set[MAX_SET]; p++)
  *p = 0;
for (i = maxk - 1; i >= 0; i--) {
  if (buf[i] != NULL && buf[i]->up != NULL) {
      xptr = buf[i]->up;
      while (xptr != NULL) {
        if (pred_set[(int)xptr->value] == 0) {
         pred_set[(int)xptr->value]++;
         first[order++] = xptr->value;
         }
        xptr = xptr->next;
       }
      }
  }
for (p = &zero_freq[0]; p < &zero_freq[MAX_SET]; p++)
  if (pred_set[(int)*p] == 0)
     first[order++] = *p;
}

/* =======================================================================
 * Name - first_pred
 *
 * Purpose -
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
static char first_pred(buf)
NodeListAType buf;
{
int i = maxk - 1;

for (;;) {
  if (buf[i] != NULL && buf[i]->up != NULL)
    return buf[i]->up->value;
  if (i == 0)
    return '\0';
  i--;
  }
}

/* =======================================================================
 * Name - init_reactive
 *
 * Purpose - initialize the predictor, esp. from a file
 *
 * Arguments:  u -- load factor to prejudice amount to read from file
 *
 * Returns     function return --
 *
 *========================================================================
 */
int init_reactive(u)
double u;
{
register int i;
EditStrType tbuf;
FILE *from, *aux;
int c;
char cbuf[TOP_K + 1], *cstart, *cend, *end;
char new_prime_file[80], old_prime_file[80];
BoolType full;
long size;

node_limit = mem_limit * 1024 / sizeof(NodeSType);
/* get a bunch of nodes for starters      */
free_nodes = (NodeSType *) MALLOC(NODE_ALLOCATION * sizeof(NodeSType));
if (free_nodes == NULL) {
  sprintf (tbuf, "cannot malloc() even %d bytes.",
      NODE_ALLOCATION * sizeof(NodeSType));
  abortit (tbuf, -1);
  }
next_free = 0;

/* set up root and pointers into model      */
CBuf[0] = Buf[0] = root = create_node();
root->up = root->next = NULL;
root->count = 1;
for (i = 1; i <= maxk; i++)
  Buf[i] = NULL;
if ((from = fopen (zero_freq_file, "r")) != NULL) {
  i = 0;
  while ((c = getc(from)) != EOF) {
    zero_freq[i++] = c;
    if ((c = getc(from)) == EOF)
      break; /* del NL */
    if (i >= MAX_SET)
      break;       /* test if okay */
    }
  } /* else use built in zero_freq[] */

if (u > 1.0)
  psize = (long) ((double)((double) maxprime) / u);
else
  psize = (long) (maxprime);

/* if user has .rk.log_file, prime from it */
if ((from = fopen (prime_file, "r")) == NULL) {
  psize = 0; /* for proper reporting */
  return;
  }

fseek (from, 0L, 2);    /* find out how long it is */
size = ftell (from);
if (size > psize) {      /* prime max chars at end  */
  fseek (from, -psize, 2);           /* start after ^G mark  */
/* on second thought, if not "logged" by rk, may be no ^Gs in the file     */
/*  while ((c = getc(from)) != EOF && c != '\07') ;*/
  }
else {
  cut_prime_mode = FALSE;
  psize = size; /* for proper reporting */
  rewind (from);
  }

if(cut_prime_mode){
	strcpy(new_prime_file, prime_file);
	strcpy(old_prime_file, prime_file);
	strcat(new_prime_file, ".new");
	strcat(old_prime_file, ".old");
	aux=fopen(new_prime_file, "w");
	if(!aux){
		printf("\n\rError cannot open (%s)\n\r", new_prime_file);
		exit(0);
		}
	}

cstart = cend = cbuf;
end = &cbuf[maxk];
full = FALSE;
while ((c = getc(from)) != EOF) {
  if(cut_prime_mode) fputc(c, aux);
  *cstart = c;
  if (full) {
    ++cstart;
    if (cstart > end)
      cstart = cbuf;
    }
  if (++cend > end) {
    cend = cbuf;
    full = TRUE;
    }
  *cend = '\0';
  move_up((char)c);
  if (memoryIsFull)
    break;
  }
fclose (from);
if(cut_prime_mode){
	fclose(aux);
	rename( prime_file, old_prime_file);
	rename( new_prime_file, prime_file);
	}

i = 0;    /* align the context */
while (cstart != cend) {
  context[i] = old_context[i] = *cstart++;
  i++;
  if (cstart > end)
    cstart = cbuf;
  }
}

/* =======================================================================
 * Name - make_a_prediction
 *
 * Purpose -
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
int make_a_prediction()
{    /* sets s to the current prediction */
ContextStrType temp;
char *a = temp;
int length, i;

if (!pred_mode)
  return;
if (eol_only_mode && *(TheEditData.dot) != '\0') {
  pred_buff[0] = '\0';
  return;
  }
strcpy (temp, context);
strcat (temp, TheEditData.current_buffer);
length = strlen(temp) - strlen(TheEditData.dot);
temp[length] = '\0';
if (length > maxk)
  a = &temp[length - maxk];

if (strcmp (old_context, a) != 0)
  pred_number = 0;
strcpy (old_context, a);

for (i = 1; i <= maxk; i++)
  CBuf[i] = NULL;
while (*a != '\0') {
  scan_up(CBuf, *a);
  a++;
  }
find_first(CBuf);
build_menu(CBuf);
}

/* =======================================================================
 * Name - move_up
 *
 * Purpose - Darkest of all JJD magic -- DJP
 *           Add character to uplist of given node, keeping uplist
 *           sorted in descending order.  Sweep through all nodes in list
 *           updating model.
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
static void move_up(c)
char c;
{
NodeSType *xptr, *fxptr, *last_ptr, *last_fptr;
enum {START, SCANNING, FOUND, END} state;
NodeSType *nptr;
NodeSType *move_up_result;
int i;

if (memoryIsFull)
  return;
CharsInModel ++;  /* partially inserted chars will also be counted... */
for (i = maxk; i > 0; i --) {
  nptr = Buf[i - 1];
  if (nptr == NULL) { /* no uplist */
    move_up_result = NULL;
    goto END_MOVE_UP;
    }
  if (nptr->up == NULL)  /* new uplist */
    state = START;
  else {
    fxptr = xptr = nptr->up;
    last_fptr = last_ptr = NULL;
    state = SCANNING;
    do {
      if (xptr == NULL)  /* end of uplist */
       state = END;
      else {
       if (xptr->count < fxptr->count) { /* remember insertion position */
         last_fptr = last_ptr;
         fxptr = xptr;
         }
       if (xptr->value == c) { /* found this character in uplist */
         state = FOUND;
         if (fxptr != xptr) {
           if (last_fptr == NULL)  /* first entry in uplist */
             nptr->up = xptr;
           else /* move entry in uplist */
             last_fptr->next = xptr;
           last_ptr->next = xptr->next;
           xptr->next = fxptr;
           }
         }
       else { /* remember this link in chain and chain forward */
         last_ptr = xptr;
         xptr = xptr->next;
         }
       }
      } while (state == SCANNING);
    }
  switch (state) {
  case FOUND:
    (xptr->count) ++;
    if (xptr->count < max_freq)
      break;
    FrequencySplits ++;
    fxptr = nptr->up;
  /*  last_fptr = fxptr; */
    while (fxptr != NULL) {     /* JJD 9-86 */
#if 0
      /* Some forgetting of old nodes may take place here, but not in this
	 version.  It is quite complicated so for simplicity we will forget it
         for now. */
      fxptr->count >>= 1; /* Forgets on halving 1 */
      /* DOESN'T FORGET A NODES SUBTREE NODES YET SO DON'T DO IT */
      /* MAY HAVE TO INCREASE max_freq TO REDUCE HALVING & OVERHEAD */
      if (fxptr->count == 0) {
       last_fptr->next = fxptr->next;
       write(DISPLAY, "1/2 free\n", 9);
       FREE(fxptr);
       fxptr = last_fptr->next;
       }
      else {
       last_fptr = fxptr;
       fxptr = fxptr->next;
       }
#else
      fxptr->count++;  /* Increment to at least 2 */
      fxptr->count >>= 1; /* Flatten count */
      fxptr = fxptr->next;
#endif
      }
    break;

  case START:
  case END:
    xptr = create_node();
    if (xptr == NULL) /* memoryIsFull */
      return;
    xptr->value = c;
    xptr->count = 1;
    xptr->up = xptr->next = NULL;
    if (state == START)
      nptr->up = xptr;
    else
      last_ptr->next = xptr;
    break;

  default:;
    }
  move_up_result = xptr;
END_MOVE_UP:
  Buf[i] = move_up_result;
  }
}

/* =======================================================================
 * Name - next_pred
 *
 * Purpose -
 *
 * Arguments:
 *
 * Returns     function return -- Keyboard status
 *
 *========================================================================
 */
int next_pred()
{        /* JJD 9-86 */
/* shouldn't we ring a bell if we run out of predictions, or something? */
if (++pred_number >= MAX_SET)
  pred_number = MAX_SET - 1;
CLEAR_FACTOR;
return OK;
}

/* =======================================================================
 * Name - previous_pred
 *
 * Purpose -
 *
 * Arguments:
 *
 * Returns     function return -- Keyboard status
 *
 *========================================================================
 */
int previous_pred()
/* shouldn't we ring a bell if we run out of predictions, or something? */
{        /* JJD 9-86 */
if (pred_number > 0)
  pred_number--;
CLEAR_FACTOR;
return OK;
}

/* =======================================================================
 * Name - prime_from_file
 *
 * Purpose -
 *
 * Arguments:
 *
 * Returns     function return -- Keyboard status
 *
 *========================================================================
 */
int prime_from_file()
{        /* JJD 9-86 */
char            filename[MAXPATHLEN];
FILE           *from;
int            c;

erase_current_edit_line();
ZERO_EDIT_LINE;

kbd_canonical(KEYBOARD);
if (memoryIsFull) {
  printf("But memory is full!  Can't expand predictive model.\n");
  fflush(stdout);
  goto ALL_DONE;
  }

printf("\r\nFile to prime from ([RETURN] to cancel): ");
fflush(stdout);
filename[0] = '\0';
gets(filename);

if (filename[0] == '\0') {
  printf("Command cancelled.\r\n");
  goto ALL_DONE;
  }
if ((from = fopen(filename, "r")) == NULL) {
  EditStrType junkStr;

  sprintf(junkStr, "%s: cannot open %s\r\n", ProgramName, filename);
  perror(junkStr);
  fflush(stderr);
  goto ALL_DONE;
  }
while ((c = getc(from)) != EOF) {
  move_up((char)c);
  if (memoryIsFull)
    break;
  /* HERE verbose_priming */
  }
fclose(from);

ALL_DONE:
display_continue();
CLEAR_FACTOR;
fflush(stdout);
kbd_raw(KEYBOARD);
return OK;
}

/* =======================================================================
 * Name - scan_up
 *
 * Purpose - Auxiliary JJD magic -- DJP
 *           Find given character in uplist of given node  Sweep through
 *           all nodes in list updating model.
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
static void scan_up(theList, c)
NodeListAType theList;
char c;
{
NodeSType * nptr;
NodeSType * xptr;
int j;

for (j = maxk; j >= 1; j--) {
  nptr = theList[j - 1];
  if (nptr == NULL) {
    xptr = NULL;
    goto END_SCAN_UP;
    }
  xptr = nptr->up;
  for (;;) {
    if (xptr == NULL) {
      goto END_SCAN_UP;
      }
    if (xptr->value == c)
      goto END_SCAN_UP;
    xptr = xptr->next;
    }
END_SCAN_UP:;
  theList[j] = xptr;
  }
}

/* =======================================================================
 * Name - show_used_nodes
 *
 * Purpose -
 *
 * Arguments:
 *
 * Returns     function return -- Keyboard status
 *
 *========================================================================
 */
int show_used_nodes()
{
EditStrType junkStr;

erase_current_edit_line();
sprintf(junkStr,
"\r\n-o (order of model) %d, -f %d (max freq, %d actual splits)\r\n",
    maxk, max_freq, FrequencySplits);
write_display(junkStr, strlen(junkStr));
sprintf(junkStr,
"%d bytes each node, %d nodes actually used, heap chunks are %d bytes\r\n",
  sizeof(NodeSType), AllocationCount, NODE_ALLOCATION * sizeof(NodeSType));
write_display(junkStr, strlen(junkStr));
sprintf(junkStr,
    "Nodes use over %dK total bytes. Limit: %dK bytes.  Already full: %s\r\n",
    (AllocationCount * sizeof(NodeSType)) / 1024, mem_limit,
    SAY_BOOL(memoryIsFull));
write_display(junkStr, strlen(junkStr));
sprintf(junkStr,
    "-n %d (chars primed from file, chose to actually read %d)\r\n",
    maxprime, psize);
write_display(junkStr, strlen(junkStr));
sprintf(junkStr, "pred_number = %d, %d characters in predictive model\r\n",
    pred_number, CharsInModel);
write_display(junkStr, strlen(junkStr));
display_continue();
CLEAR_FACTOR;
return OK;
}

/* =======================================================================
 * Name - update_the_model
 *
 * Purpose -
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
int update_the_model(s)
char *s;
{ /* adds s into the model & updates log */
char *a = &s[0], *c = &s[0];
int length;
FILE *to;
EditStrType   temp;

/**** change: Dejan M. March 1990 - introduce global LOG_ALL ****/
 
/* Update the log file, no matter what. */
if( log_all_mode || (s[0] != '\n')) { 
  /* reopen to append log, otherwise create it */
  if ((to = fopen(log_file, "a")) == NULL) {
    sprintf(temp, "%s: cannot reopen or create: %s", ProgramName, log_file);
    perror(temp);
    abortit("", -1);
    }
  /* now log can be manipulated and still used */
  fputs(s, to);
  fflush(to);
  fclose(to);
  }

/* If predictive model is full, we're done. */
if (memoryIsFull)
  return;

/* Build new context */
if (strlen(s) < maxk) {
  strcpy (temp, context);
  strcat (temp, s);
  length = strlen(temp);
  if (length > maxk)
    a = &temp[length - maxk];
  else
    a = temp;
  }
strcpy (context, a);

/* Apply new context to model */
while (*c != '\0') {
  move_up(*c);
  if (memoryIsFull)
    break;
  c++;
  }
}
