#define KBDSYS_C TRUE
/*========================================================================
 *
 * Name - %M%
 *
 * Version:    %I%
 *
 * ccsid:      %W% - %G% %U%
 * from:       %F%
 * date:       %H% %T%
 *
 * %Q%
 *
 * Description: System interface to keyboard
 *
 *========================================================================
*/
#include <stdio.h>

#include "rkglobal.h"
#include "system.h"

#include "kbdsys.h"


/* =======================================================================
 * Name - get_line_char
 *
 * Purpose - Return line control char (system dependent)
 *
 * Arguments:  fd -- terminal to query
 *             what -- which one to get
 *
 * Returns     function return -- The char, or -1 for error
 *
 *========================================================================
 */
int get_line_char(fd, what)
int fd;
LineCharEType what;
{
char c;

#if defined(FLG_AIX_UNIX)
struct termio info;
/* #elif defined(FLG_HPUX_UNIX) */
#else
#if defined(FLG_HPUX_UNIX)
struct termios info;
#else
struct tchars   pty_tchars;
struct ltchars  pty_ltchars;
#endif
#endif

#if defined(FLG_AIX_UNIX)
  ioctl(fd, TCGETA, (int)&info);
/* #elif defined(FLG_HPUX_UNIX) */
#else
#if defined(FLG_HPUX_UNIX)
  ioctl(fd, TCGETATTR, (int)&info);
#else
  if (what == LINE_FLUSH || what == LINE_SUSPEND)
    ioctl(fd, TIOCGLTC, (int)&pty_ltchars);
  else
    ioctl(fd, TIOCGETC, (int)&pty_tchars);
#endif
#endif

switch (what) {
case LINE_EOF:
#if defined(FLG_AIX_UNIX) || defined(FLG_HPUX_UNIX)
  c = info.c_cc[VEOF];
#else
  c = pty_tchars.t_eofc;
#endif
  break;

case LINE_FLUSH:
#if defined(FLG_AIX_UNIX) || defined(FLG_HPUX_UNIX)
  c = -1;
#else
  c = pty_ltchars.t_flushc;
#endif
  break;

case LINE_INTR:
#if defined(FLG_AIX_UNIX) || defined(FLG_HPUX_UNIX)
  c = info.c_cc[VINTR];
#else
  c = pty_tchars.t_intrc;
#endif
  break;

case LINE_QUIT:
#if defined(FLG_AIX_UNIX) || defined(FLG_HPUX_UNIX)
  c = info.c_cc[VQUIT];
#else
  c = pty_tchars.t_quitc;
#endif
  break;

case LINE_START:
#if defined(FLG_AIX_UNIX)
  c = '\021'; /* always ^Q */
/* #elif defined(FLG_HPUX_UNIX) */
#else
#if defined(FLG_HPUX_UNIX)
  c = info.c_cc[VSTART];
#else
  c = pty_tchars.t_startc;
#endif
#endif
  break;

case LINE_STOP:
#if defined(FLG_AIX_UNIX)
  c = '\023'; /* always ^S */
/* #elif defined(FLG_HPUX_UNIX) */
#else
#if defined(FLG_HPUX_UNIX)
  c = info.c_cc[VSTOP];
#else
  c = pty_tchars.t_stopc;
#endif
#endif
  break;

case LINE_SUSPEND:
#if defined(FLG_AIX_UNIX)
  c = -1;
/* #elif defined(FLG_HPUX_UNIX) */
#else
#if defined(FLG_HPUX_UNIX)
  c = info.c_cc[VSUSP];
#else
  c = pty_ltchars.t_suspc;
#endif
#endif
  break;

default:
  c = -1;
  break;
  }
return c;
}

/* =======================================================================
 * Name - getTty
 *
 * Purpose - Get keyboard modes
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
int getTty(fd, x)
int fd;
TermInfoSType * x;
{
#if defined(FLG_AIX_UNIX)
return ioctl(fd, TCGETA, (int)x);
/* #elif defined(FLG_HPUX_UNIX) */
#else
#if defined(FLG_HPUX_UNIX)
return ioctl(fd, TCGETATTR, (int)x);
#else
return ioctl(fd, TIOCGETP, (int)x);
#endif
#endif
}

/* =======================================================================
 * Name - kbd_canonical
 *
 * Purpose - Set keyboard input to normal, cooked mode
 *
 * Arguments:  fd -- descriptor to change
 *
 * Returns     function return -- Keyboard status
 *
 *========================================================================
 */
void kbd_canonical(fd)
int fd;
{
setTty(fd, &cooked_stdin);
}

void kbd_init()
{

getTty(KEYBOARD, &cooked_stdin); /* grab original value */

/* Build nice description of canonical keyboard */
#if defined(FLG_AIX_UNIX) || defined(FLG_HPUX_UNIX)
  cooked_stdin.c_lflag |= ICANON | ECHO | ISIG;
  cooked_stdin.c_oflag |= OPOST | ONLCR;
#else
  cooked_stdin.sg_flags &= ~(RAW | CBREAK| LCASE);
  cooked_stdin.sg_flags |= (ECHO | CRMOD | FF0);
#endif

#if defined(FLG_HPUX_UNIX)
  /* hpux doesn't init these values properly... */
  cooked_stdin.c_cc[VINTR]  = '\003';
  /* no flush */
  cooked_stdin.c_cc[VSTART]  = '\025';
  cooked_stdin.c_cc[VSTOP]  = '\021';
  cooked_stdin.c_cc[VEOF]  = '\004';
  cooked_stdin.c_cc[VQUIT]  = '\034';
  cooked_stdin.c_cc[VSUSP]  = '\032';
#endif

raw_stdin = cooked_stdin; /* copy, then change to reflect raw mode */

#if defined(FLG_AIX_UNIX) || defined(FLG_HPUX_UNIX)
  raw_stdin.c_lflag &= ~(HUPCL | ICANON | ISIG);

  raw_stdin.c_cc[VMIN] = 1; /* 1 char min */
  raw_stdin.c_cc[VTIME] = 0; /* 0 decisec delay -- respond immediately */

  raw_stdin.c_lflag &= ~(ECHO);
#else
  raw_stdin.sg_flags |= (CBREAK|RAW|CRMOD);
  raw_stdin.sg_flags &= ~(ECHO);
#endif
}

/* =======================================================================
 * Name - kbd_raw
 *
 * Purpose - Set keyboard input to literal, uninterpreted, "raw" mode
 *
 * Arguments:  fd -- file descriptor to modify
 *
 * Returns     function return -- Keyboard status
 *
 *========================================================================
 */
void kbd_raw(fd)
int fd;
{
setTty(fd, &raw_stdin);
}

/* =======================================================================
 * Name - setTty
 *
 * Purpose - Set keyboard modes
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
int setTty(fd, x)
int fd;
TermInfoSType * x;
{
#if defined(FLG_AIX_UNIX)
return ioctl(fd, TCSETA, (int)x);
/* #elif defined(FLG_HPUX_UNIX) */
#else
#if defined(FLG_HPUX_UNIX)
return ioctl(fd, TCSETATTR, (int)x);
#else
return ioctl(fd, TIOCSETP, (int)x);
#endif
#endif
}
