#define KBDCHECK_C TRUE
/*========================================================================
 *
 * Name - %M%
 *
 * Version:    %I%
 *
 * ccsid:      %W% - %G% %U%
 * from:       %F%
 * date:       %H% %T%
 *
 * %Q%
 *
 * Description:
 *
 * Ascii reads characters from the keyboard in raw mode and writes the
 * numerical equvalent in octal and decimal as well as its standard mnemonic.
 *
 * Originally written on 4.1 by J. Goodman (I think).
 * Rewritten by Dave Cohrs <dave@cs.wisc.edu>
 *
 *
 *     Modified 1/19/86 by David Parter to also show hex.
 *
 *      Modified 29 Dec 89 by D. Jason Penney to allow meta-characters to
 *                         be displayed.
 *========================================================================
 */

#include "rkglobal.h"
#include "system.h"
#include "kbdsys.h"

#define QUIT_THRESHOLD 3

char   *cval[128] = {
       "^@",
       "^A",
       "^B",
       "^C",
       "^D",
       "^E",
       "^F",
       "^G",
       "^H",
       "^I",
       "^J",
       "^K",
       "^L",
       "^M",
       "^N",
       "^O",
       "^P",
       "^Q",
       "^R",
       "^S",
       "^T",
       "^U",
       "^V",
       "^W",
       "^X",
       "^Y",
       "^Z",
       "^[",
       "^\\",
       "^]",
       "^^",
       "^_",
       "<sp>",
       "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-",
       ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":",
       ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G",
       "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T",
       "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a",
       "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n",
       "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{",
       "|", "}", "~",
       "^?",
       };

char   *comment[128] = {
       "NUL (null)",
       "SOH (start of heading)",
       "STX (start of text)",
       "ETX (end of text)",
       "EOT (end of transmission)",
       "ENQ (enquiry)", /* ^e */
       "ACK (acknowledge)",
       "BEL (bell)",
       "BS  (backspace)",
       "HT  (horizontal tab)",
       "LF  (line feed)", /* ^j */
       "VT  (vertical tab)",
       "FF  (form feed)",
       "CR  (carriage return)",
       "SO  (shift out)",
       "SI  (shift in)", /* ^o */
       "DLE (data link escape)",
       "DC1 (device control 1)",
       "DC2 (device control 2)",
       "DC3 (device control 3)",
       "DC4 (device control 4)", /* ^t */
       "NAK (negative acknowledge)",
       "SYN (synchronous idle)",
       "ETB (end of transmission block)",
       "CAN (cancel)",
       "EM  (end of medium)", /* ^y */
       "SUB (substitute character)",
       "ESC (escape)", /* ^[ */
       "FS  (file separator)",  /* ^\ */
       "GS  (group separator)",  /* ^] */
       "RS  (record separator)",  /* ^^ */
       "US  (unit separator)",  /* ^_ */
       "SP  (space)",
       "exclamation point", "double quote", "sharp (number sign)", "dollar",
        "percent", "ampersand",
        "apostrophe", "left parenthesis", "right parenthesis",
        "splat (asterisk)", "plus", "comma", "hyphen (minus)",
       "period", "slash (solidus)", "zero", "one", "two", "three", "four", "five",
        "six", "seven", "eight", "nine", "colon",
       "semicolon", "less-than", "equals", "greater-than", "question mark",
        "at-sign", "A", "B", "C", "D", "E", "F", "G",
       "H", "big eye", "J", "K", "L", "M", "N", "big oh", "P", "Q", "R", "S", "T",
       "U", "V", "W", "X", "Y", "Z", "left bracket", "backslash (reverse solidus)",
        "right bracket", "carat (circumflex accent)",
        "underscore",
        "grave accent", "a",
       "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "small ell", "m", "n",
       "small oh", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z",
        "left brace",
       "bar (vertical line)", "right brace", "tilde (overline)",
       "DEL (delete)",
       };


main(argc, argv)
int argc;
char *argv[];
{
register int csav = 0200; /* invalid */
register int ccnt = 0;
unsigned char eight_bit_mode = 0;

if (argc > 1) {
  if (strcmp(argv[1], "-8") == 0)
    eight_bit_mode = 1;
  else {
    printf("Usage: %s [-8]\n", argv[0]);
    exit(1);
    }
  }

kbd_init();
printf("dec hex  oct  char  other\n");
printf("--- ---- ---- ----- -----\n");
fflush(stdout);

kbd_raw(KEYBOARD);

while (1) {
  unsigned char c;
  unsigned char testChar;

  read(KEYBOARD, (char *)&c, 1);
  if (!eight_bit_mode)
    testChar = c & 127;
  else
    testChar = c;
  printf("%3d 0x%-02X 0%-03o ", testChar, testChar, testChar);
  if (testChar >= 128) {
    testChar &= 127;
    printf("!%-4s Meta-", cval[testChar]);
    }
  else
    printf("%-5s ", cval[testChar]);
  printf("%s\r\n", comment[testChar]);
  if (c == csav) {
    if(++ccnt == (QUIT_THRESHOLD - 1)) {
      kbd_canonical(KEYBOARD);
      exit(0);
      }
    }
  else
    ccnt = 0;
  csav = c;
  }
}
