#if !defined(FUNCTIONS_H)
#define FUNCTIONS_H TRUE
/*========================================================================
*
* Name - %M%
*
* Version:     %I%
*
* ccsid:       %W% - %G% %U%
* from:        %F%
* date:        %H% %T%
*
* %Q%
*
* Description: The line editing functions, and some miscellany
*
*========================================================================*/
#define STRIP_PARITY(ch) ((ch) & 127)

/* following is in display.c */
int show_termcap_info();		/* was report_termcap */

/* following are in complete.c */
void    clearCompletion();    /* internal routine */
int    command_completion();
int    file_completion();
int    repeater();

/* following are in kbdbind.c */
int    describe_bindings();
int    input_key_bindings();
int    meta_prefix();       /* internal routine */

/* following are in reactive.c */
int    next_pred();
int    previous_pred();
int    prime_from_file();
int    show_used_nodes();

/* following are in functions.c */
int    BOGUS();
int    accept_forward_char();
int    accept_forward_word();
int    accept_to_end_of_line();
int    accept_to_eol();                /* Dejan */
int    backspace_char();
int    backspace_word();
int    backward_char();
int    backward_paren();
int    backward_word();
int    beginning_of_line();
int    capitalize_word();
int    clear_display();
int    close_paren();
int    dash_to_ul_word();
int    delete_char();
int    delete_char_or_insert_eof();   /* Dejan */
int    delete_region_to_killbuffer();
int    delete_word();
int    discard_current_edit_line();
int    discard_rest_of_line();
int    end_of_line();
int    exchange_mark_and_set();
int    finish_editing_line();
int    forward_char();
int    forward_paren();
int    forward_word();
int    increment_factor();
int    insert_eof_char();
int    insert_flush_char();
int    insert_interrupt_char();
int    insert_quit_char();
int    insert_start_char();
int    insert_stop_char();
int    insert_suspend_char();
int    lowercase_word();
int    new_working_directory();
int    next_line();
int    open_paren();
int    previous_line();
int    quote_char();
int    run_mesg();



#if 0
int    run_pp();
#endif

int    run_ruptime();
int    run_talk();
int    run_tty_program();
int    run_write();
int    self_insert();
int    set_mark();
int    show_arguments();
int    show_mark();
int    show_system_toggles();
int    show_version();
int    toggle_add_space_mode();
int    toggle_eol_longer_mode();
int    toggle_include_stuff_mode();      /* Dejan */
int    toggle_lisp_mode();
int    toggle_nl_truncate_mode();
int    toggle_only_at_eol_mode();
int    toggle_pred_mode();
int    toggle_record_all_mode();                /* Dejan */
int    toggle_show_eol_mode();
int    toggle_wrap_mode();	            /* Dejan */
int    twiddle_chars();
int    ul_to_dash_word();
int    uppercase_word();
int    yank_from_kill_buffer();

#endif
