#if !defined(DISPLAY_H)
#define DISPLAY_H TRUE
/*========================================================================
*
* Name - %M%
*
* Version:     %I%
*
* ccsid:       %W% - %G% %U%
* from:        %F%
* date:        %H% %T%
*
* %Q%
*
* Description: Interface to abstract display module
*
*========================================================================*/

/* This is the size of the user's display, in character display cells.
   Initializing and resetting these is unix implementation dependent. */
int displayColumns;
int displayRows;

/* The user's command line is displayed as a single "logical line",
   which contains
   1. a "prompt" from the master pty,
   2. any characters the user has accepted,
   3. a prediction and
   4. a second set of characters the user has accepted.

  Any of these may be zero-length, depending on the current
  inputs and operating modes.
*/
EditStrType PromptStr;
int PromptStrSize
#if defined(DISPLAY_C)
= 0
#endif
;

/* The current prediction, null-terminated */
EditStrType pred_buff;

/* Operations occur at current logical cursor position, which has
   expanded all control characters but does not take window wrap into
   account.  Top left corner of line is 0.  The first position at which
   user input will be inserted is, correspondingly, PromptStrSize.

   The following routines manipulate this "logical line" in terms of
   editing changes into its new current arrangement.
*/

int CurrentCursor;

/* Following booleans indicate if prediction and edit line respectively
   are currently on display on the screen */
BoolType pred_on_display
#if defined(RK_C)
= FALSE
#endif
;

BoolType edit_on_display
#if defined(RK_C)
= TRUE
#endif
;


/* USED_COLUMNS are the number of columns we are actually printing to.
   you could set USED_COLUMNS to (displayColumns - 1) to
  chicken out on using column 80 in the display.  As it is, there's
  some pretty funky stuff in display\TO_NEXT_LINE that will try to brave it out.
*/
#define USED_COLUMNS displayColumns

void bell();                   /* insert termcap alert */
void clear_terminal();         /* blast terminal, repaint all */
void display_continue();       /* refresh after catastrophic messages */
void display_pred_buffer();    /* Make prediction appear */
void draw_current_edit_line();         /* make everything except pred visible */
void erase_current_edit_line(); /* clear all but "prompt", position cursor
                                 after prompt */
void erase_pred_buffer();      /* Make prediction vanish */
void erase_right();            /* erase characters to right of cursor */
void flush_pty();              /* write bytes to display, making prompt_st */
void flush_termcap();          /* flush all termcap commands to display */
int get_char_display_length();         /* predict length in chars of single char */
int get_display_length();      /* predict length in characters of a
                                  null-terminated string */
int get_termcap_stuff();       /* initialization routine */
int insert_str();              /* insert chars after current display pos */
int move_left();               /* move cursor left on logical line, but not
                                  past prompt */
int overprint_chr();           /* overwrite single character */
int overprint_str();           /* overwrite null-terminated string */
void redraw_prompt();          /* assumes cursor at column 1; refresh prompt */
void resizeWindow();           /* Put user and pty window sizes in synch */
void report_termcap();                 /* report state of termcap being used */
void set_underline_mode();     /* reset termcap after setting underline mode */
void write_display();          /* unbuffered write to the display */
char *xlat_termcap();          /* translate a termcap code */

#endif
