#if !defined(DEFAULTS_H)
#define DEFAULTS_H TRUE
/*========================================================================
*
* Name - %M%
*
* Version:     %I%
*
* ccsid:       %W% - %G% %U%
* from:        %F%
* date:        %H% %T%
*
* %Q%
*
* Description: Various external defaults, parameters, and sizes
*
*========================================================================*/

#define DEFAULT_NUM_BUFFERS 77
#define DEFAULT_PRED_MODE TRUE
#define DEFAULT_SHOW_EOL_MODE TRUE
#define DEFAULT_NL_TRUNCATE_MODE TRUE
#define DEFAULT_EOL_ONLY_MODE TRUE
#define DEFAULT_EOL_LONGER_MODE TRUE
#define DEFAULT_LISP_MODE FALSE
#define DEFAULT_ADD_SPACE_MODE TRUE
#define DEFAULT_SILENT FALSE
#define DEFAULT_LOGIN FALSE
#define DEFAULT_UNDERLINE_MODE FALSE
/**** changes  Dejan M.  March 1990 ****/
#define DEFAULT_WRAP_MODE         FALSE
#define DEFAULT_CUT_PRIME_MODE    FALSE
#define DEFAULT_LOG_ALL           FALSE
#define DEFAULT_SKIP_NONWORD_MODE TRUE
#define DEFAULT_CALLED_FROM_CMD_LINE FALSE

#define DEFAULT_MAXPRIME 32000 /* characters to prime from PRIME_FILE */
#define DEFAULT_MAX_LEN 8      /* Maximum length of pred, except at eol */
#define DEFAULT_MAX_EOL 42     /* maximum length of pred at eol, if enabled */
#define DEFAULT_MAXK 8                /* Default order of model (-o) */
#define DEFAULT_MAX_FREQ 127   /* -f, cutoff at which model flattens */
#define DEFAULT_MEM_LIMIT 4096 /* max nodes to create, in K bytes */
#define DEFAULT_EIGHT_BIT_MODE FALSE /* whether to allow meta- chars */

#define ZERO_FREQ_FILE "/.rk.zero_freq"
#define PRIME_FILE "/.rk.log_file"
#define LOG_FILE "/.rk.log_file"
#define KEY_FILE "/.rk.keys"

#define TOP_K          21 /* Maximum allowed model order, no better >12 */

/* The following definitions are for the maximum permitted frequency
   (-f) parameter.  Occurences of various patterns are reference-counted
   up to this maximum, after which point the predictive model loses
   discretion.

  The size of this reference count is included in a memory allocation that
  occurs quite frequently during the processing of the predictive model.
  Thus, you might be interested in limiting it to say, a byte.

  Note: MAX_FREQ must tolerate incrementing without overflowing.

  However, neither the SPARCstation, the Sun-386i, or the Sun-3 seem
  to want to save space in this way, allocating 12 bytes for the struct
  instead of 10.  This presumably gives better memory alignment for their
  faster CPUs.

  On the other hand, your machine might save space in this way.  If so,
  reverse the following to #if 1...
*/
#if 0
#define MAX_FREQ 254
typedef unsigned char FrequencyType;
#else
#define MAX_FREQ 65534
typedef unsigned short FrequencyType;
#endif

#define FACTOR_MAXIMUM 255 /* maximum multiplier allowed, must fit in an int */

#define MAXEXTENSIONS 12  /* Largest size of a key meta sequence */

char *zero_freq_file;
char *log_file;                        /* file to log commands to */
char *prime_file;              /* file to initially prime from */

BoolType add_space_mode
#if defined(RK_C)
= DEFAULT_ADD_SPACE_MODE
#endif
;

BoolType eol_longer_mode
#if defined(RK_C)
= DEFAULT_EOL_LONGER_MODE
#endif
;
BoolType eol_only_mode
#if defined(RK_C)
= DEFAULT_EOL_ONLY_MODE
#endif
;

BoolType lisp_mode
#if defined(RK_C)
= DEFAULT_LISP_MODE
#endif
;

BoolType login
#if defined(RK_C)
= DEFAULT_LOGIN
#endif
;

BoolType log_all_mode   /* Dejan */
#if defined(RK_C)
= DEFAULT_LOG_ALL
#endif
;

BoolType wrap_mode      /* Dejan */
#if defined(RK_C)
= DEFAULT_WRAP_MODE
#endif
;

BoolType cut_prime_mode  /* Dejan */
#if defined(RK_C)
= DEFAULT_CUT_PRIME_MODE
#endif
;

BoolType skip_nonword_mode  /* Dejan */
#if defined(RK_C)
= DEFAULT_SKIP_NONWORD_MODE
#endif
;

int max_eol
#if defined(RK_C)
= DEFAULT_MAX_EOL
#endif
;

int max_freq
#if defined(RK_C)
= DEFAULT_MAX_FREQ
#endif
;

int maxk
#if defined(RK_C)
= DEFAULT_MAXK
#endif
;

int max_len
#if defined(RK_C)
= DEFAULT_MAX_LEN
#endif
;

int maxprime
#if defined(RK_C)
= DEFAULT_MAXPRIME
#endif
;

BoolType nl_truncate_mode
#if defined(RK_C)
= DEFAULT_NL_TRUNCATE_MODE
#endif
;

int num_buffers
#if defined(RK_C)
 = DEFAULT_NUM_BUFFERS
#endif
;

BoolType pred_mode
#if defined(RK_C)
= DEFAULT_PRED_MODE
#endif
;

BoolType show_eol_mode
#if defined(RK_C)
= DEFAULT_SHOW_EOL_MODE
#endif
;

BoolType silent
#if defined(RK_C)
= DEFAULT_SILENT
#endif
;

BoolType underlineMode
#if defined(RK_C)
= DEFAULT_UNDERLINE_MODE
#endif
;

long mem_limit
#if defined(RK_C)
= DEFAULT_MEM_LIMIT
#endif
;

BoolType eight_bit_mode
#if defined(RK_C)
= DEFAULT_EIGHT_BIT_MODE
#endif
;

BoolType called_from_cmd_line
#if defined(RK_C)
= DEFAULT_CALLED_FROM_CMD_LINE
#endif
;

#endif
