#define COMPLETE_C TRUE
/*========================================================================
 *
 * Name - %M%
 *
 * Version:    %I%
 *
 * ccsid:      %W% - %G% %U%
 * from:       %F%
 * date:       %H% %T%
 *
 * %Q%
 *
 * Description: Implementations of command_completion and file_completion
 *
 *========================================================================
 */

#include <ctype.h>
#include <stdio.h>

#include "rkglobal.h"
#include "rk.h"
#include "defaults.h"
#include "system.h"
#include "display.h"
#include "kbdbind.h"
#include "utl.h"

#include "functions.h"


#define MAX_DIR_TO_SEARCH  32    /* More will be ignored */
#define MAX_FILES_TO_SAVE  128    /* More will be ignored */

static void file_init();
static void command_init();
static BoolType glob(); /* glob pattern match -- 100 lines of magic */
static int ssort();

static char *f_name[MAX_FILES_TO_SAVE];
static int filesMatched = 0;
static BoolType completionInProgress = FALSE;
static BoolType past_first = FALSE;
static int curMatch = 0;

/* =======================================================================
 * Name - clearCompletion
 *
 * Purpose - Clear floating command and file completion state
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
void clearCompletion()
{
int i;

if (!completionInProgress)
  return;
for (i = 0; i < filesMatched; i ++) {
  if (f_name[i] != NULL)
    FREE(f_name[i]);
  f_name[i] = NULL;
  }
filesMatched = 0;
completionInProgress = FALSE;
past_first = FALSE;
curMatch = 0;
}

/* =======================================================================
 * Name - command_completion
 *
 * Purpose - Complete user command based on input, current directory,
 *           and current path
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
int command_completion()
{
EditStrType tstring;
int
     charLength,
     displayLength,
     newLength;

if (!completionInProgress) {
  command_init(tstring);
  if (filesMatched == 0) {
    bell();
    goto ALL_DONE;
    }
  completionInProgress = TRUE;
  displayLength = get_display_length(tstring);
  charLength = strlen(tstring);
  curMatch = 0;
  }
else {
  displayLength = get_display_length(f_name[curMatch]);
  charLength = strlen(f_name[curMatch]);
  curMatch = (curMatch + 1) % filesMatched;
  }

/* Erase previous filename (not directory, though */
move_left(displayLength);
TheEditData.dot -= charLength;
erase_right(displayLength, TheEditData.dot);
edit_remove(charLength);

/* Write new filename in */
newLength = strlen(f_name[curMatch]);
insert_str(f_name[curMatch], newLength, TheEditData.dot);
/* We already know name will fit... */
edit_insert(f_name[curMatch], newLength);
/* And our cursor is after the new filename */
TheEditData.dot += newLength;

edit_on_display = TRUE;
ALL_DONE:
return OK;
}

/* =======================================================================
 * Name - command_init
 *
 * Purpose - Complete list for command completion
 *
 * Arguments:
 *
 * Returns     function return --
 *             tstring -- symbol we extracted from line to do match with
 *
 *========================================================================
 */
static void command_init(tstring)
EditStrType tstring;
{
char *path_var,    /* points to the environment variable PATH */
     *tchar,
     *paths[MAX_DIR_TO_SEARCH];    /* JJD 3-89 changed to ptrs */
EditStrType d_name;
EditStrType de_name;
EditStrType t_name;
int  count,
     num_dirs=0,    /* number of directories to look in */
     current_search_directory, /* the current directory to look at */
     i;

DIR  *dir_pointer = NULL;
char *startPos;

SysDirectSType *d_entry;
struct stat   buf;         /* JJD 3-89 added */

for (i = 0; i < MAX_FILES_TO_SAVE; i ++)
  f_name[i] = NULL;
for (i = 0; i < MAX_DIR_TO_SEARCH; i ++)
  paths[i] = NULL;
filesMatched = 0;


/* Start scanning left; skip  until white space */
if (TheEditData.dot == &TheEditData.current_buffer[0])
  startPos = &TheEditData.current_buffer[0];
else
  startPos = TheEditData.dot - 1;
for (; !isspace(*startPos) && startPos > &TheEditData.current_buffer[0];
    startPos--);
/* Now either at preceding whitespace or beginning of buffer */
if (startPos != TheEditData.current_buffer)
  startPos++;

/* save the string to look for */
strncpy(tstring, startPos, TheEditData.dot - startPos);
tstring[TheEditData.dot - startPos] = '\0';

/* Crack user's path */
path_var = getenv("PATH");
if (path_var == NULL)         /* JJD 3-89 added test */

  goto ALL_DONE;

/* JJD: this assumes a "normal" PATH, which it is 99.99% likely to be */
tchar = &path_var[0];
if (path_var[0] == ':')  /* Path can begin with ":" (noise) */
  tchar++;
while (*tchar != '\0') { /* Collect path directories */
  count = 0;
  while (*tchar != ':' && *tchar != '\0') /* collect characters in a path */
    d_name[count++] = *tchar++;
  if (*tchar == ':') /* Skip a trailing ":",
                        esp. don't make empty path at end */
    tchar++;
  d_name[count] = '\0';

  paths[num_dirs] = MALLOC(strlen(d_name) + 1);
  if (paths[num_dirs] == NULL)
    /* goto TOO_MANY_DIRS; You won't get very far.  Just give up. */
    goto ALL_DONE;

  strcpy(paths[num_dirs], d_name);
  if (++num_dirs >= MAX_DIR_TO_SEARCH)
    goto TOO_MANY_DIRS; /* JJD 3-89 forget the rest*/
  }

TOO_MANY_DIRS:
/* now have num_dirs directories to search for the command in */
/* JJD 3-89 NOW CHECKS FOR EXECUTE PERMISSION and NOT A DIRECTORY,      */
/*       THEN SORTS IN ALPHA ORDER */
/* DJP 11-89:  Now removes duplicates. */

for (current_search_directory = 0;
    current_search_directory < num_dirs; current_search_directory++) {

/* Build directory name and open directory */
  strcpy(d_name, paths[current_search_directory]);
  strcat (d_name, "/");
  if ((dir_pointer = opendir(&paths[current_search_directory][0])) == NULL)
    continue;
  d_entry = readdir(dir_pointer);
  for (;d_entry != NULL; d_entry = readdir(dir_pointer)) { /* Scan directory */
    int j;

    strcpy(de_name, d_entry->d_name); /* Just save away */
    /* Do basic tests */
    if (strncmp(tstring, de_name, strlen(tstring)) != 0 &&
       !glob(tstring, de_name))
      continue;
    if (strcmp(".", de_name) == 0 || strcmp("..", de_name) == 0)
      continue; /* JJD 3-89 del . .. */

    /* See if it looks like a command.  Build filename, and examine */
    strcpy(t_name, d_name);
    strcat(t_name, de_name);
    if (access(t_name, X_OK) != 0) /* executable? */
      continue;
    if (stat(t_name, &buf) != 0) /* accessible? */
      continue;
    if ((buf.st_mode & S_IFMT) == S_IFDIR) /* directories don't count */
      continue;

    /* Remove duplicates */
    for (j = 0; j < filesMatched; j ++) {
      if (strcmp(f_name[j], de_name) == 0)
       goto HAVE_COMMAND;
      }

    /* See if name will fit onto edit line */
    j = strlen(de_name);
    if (!CHECK_INSERT(j)) /* name won't fit */
      continue;

    /* Allocate name */
    f_name[filesMatched] = MALLOC(j + 1);
    if (f_name[filesMatched] == NULL)
      goto ALL_DONE; /* Just forget the rest */
    strcpy(f_name[filesMatched], de_name);
    if (++filesMatched >= MAX_FILES_TO_SAVE)
      goto ALL_DONE; /* JJD 3-89 above */
    HAVE_COMMAND:;
    }
  if (dir_pointer != NULL) {
    closedir(dir_pointer);
    dir_pointer = NULL;
    }
  }

ALL_DONE:
if (dir_pointer != NULL) {
  closedir(dir_pointer);
  dir_pointer = NULL;
  }
for (i = 0; i < MAX_DIR_TO_SEARCH; i ++)
  if (paths[i] != NULL)
    FREE(paths[i]);
if (filesMatched > 0)
  ssort(f_name, filesMatched); /* JJD 3-89, alpha */
}

/* =======================================================================
 * Name - file_completion
 *
 * Purpose - Complete filename based on user input
 *
 * Arguments:
 *
 * Returns     function return --
 *
 *========================================================================
 */
/* AN IDEA: a better way would look ahead a next char, if not this, put     */
/*      in the read buffer and return, else stay here - write (un)getc. */

int file_completion()
{
EditStrType tstring;

int
    displayLength,
    charLength,
    newLength;

if (!completionInProgress) {
  file_init(tstring);
  if (filesMatched == 0) {
    bell();
    goto ALL_DONE;
    }
  completionInProgress = TRUE;
  displayLength = get_display_length(tstring);
  charLength = strlen(tstring);
  curMatch = 0;
  }
else {
  displayLength = get_display_length(f_name[curMatch]);
  charLength = strlen(f_name[curMatch]);
  curMatch = (curMatch + 1) % filesMatched;
  }
move_left(displayLength);
TheEditData.dot -= charLength;
erase_right(displayLength, TheEditData.dot);
edit_remove(charLength);

/* Write new name on display */
newLength = strlen(f_name[curMatch]);
insert_str(f_name[curMatch], newLength, TheEditData.dot);
/* We already know name will fit */
edit_insert(f_name[curMatch], newLength);
TheEditData.dot += newLength;

edit_on_display = TRUE;

ALL_DONE:
return OK;
}

/* =======================================================================
 * Name - file_init
 *
 * Purpose - Perform initialization of file completion list
 *
 * Arguments:
 *
 * Returns     function return -- Number of files that were matched
 *             tstring -- the pattern we did the match on
 *
 *========================================================================
 */
static void file_init(tstring)
EditStrType tstring;
{
char *cwd,
     *tchar;
EditStrType de_name; /* dir entry name */
EditStrType full_path;
EditStrType t_name;

DIR  *dir_pointer = NULL;   /* JJD 7-90 initialize in case myabspath() fails */
SysDirectSType *d_entry;

int i;

struct stat   buf;
char *startPos;

for (i = 0; i < MAX_FILES_TO_SAVE; i ++)
  f_name[i] = NULL;
filesMatched = 0;

/* now look for start of filename to match */
if (TheEditData.dot == &TheEditData.current_buffer[0])
  startPos = &TheEditData.current_buffer[0];
else
  startPos = TheEditData.dot - 1;
for (; !isspace(*startPos) && startPos != TheEditData.current_buffer;
    startPos--);
/* Point at beginning of word */
if (startPos != TheEditData.current_buffer)
  startPos++;

/* save the string to look for */
strncpy(tstring, startPos, TheEditData.dot - startPos);
tstring[TheEditData.dot - startPos] = '\0';

/* See if it has a "/" in it anywhere... */
for (tchar = &tstring[0]; *tchar != '\/' && *tchar != '\0'; tchar++)
  ;
if (*tchar == '\/') { /* it does */
  strcpy(full_path, tstring);
  tchar = &full_path[0];
  /* get basename from pattern */
  while (*tchar != '\0') /* by going to end */
    tchar++;
  while (*tchar != '\/' && tchar != &full_path[0])  /* and then backing up */
    tchar--;
  *tchar = '\0'; /* remove basename from full_path */
  tchar ++; /* copy rest to tstring */
  strcpy(tstring, tchar);
  startPos += strlen(full_path) + 1; /* keep rest of full path for user */
  if (strlen(full_path) == 0)
    strcpy(full_path, "/"); /* minimal case */
  if (full_path[0] == '~' || full_path[0] == '$') {
    /* concession to David Monnie - recognize ~davidm/foo and $foo/bar... */
    EditStrType tempStr;
    strcpy(tempStr, full_path); /* Save, when we start to overwrite */
    if (myabspath(tempStr, full_path) != 0)
      goto ALL_DONE;	/* JJD 7-90 Bug if dir_pointer unset, init to NULL */
    }
  cwd = full_path;
  }
else { /* just current directory */
  getwd(full_path);
  cwd = full_path;
  }

/* Open it to look */
if ((dir_pointer = opendir(cwd)) == NULL) {
  goto ALL_DONE;
  }

/* now look for any matching filenames and increment match if we find one */
d_entry = readdir(dir_pointer);
for (; d_entry != NULL; d_entry = readdir(dir_pointer)) {
  int nameLength;

  strcpy(de_name, d_entry->d_name); /* save */

  /* Do basic tests */
  if (strncmp(tstring, de_name, strlen(tstring)) != 0 &&
      !glob(tstring, de_name))
    continue;
  if (strcmp(".", de_name) == 0 || strcmp("..", de_name) == 0)
    continue; /* JJD 3-89 del ... */

  /* Build full name */
  strcpy(t_name, full_path);
  strcat(t_name, "/");
  strcat(t_name, de_name);

  /* Eliminate a few ;*/
  if (stat(t_name, &buf) != 0) /* accessible? */
    continue;
  if ((buf.st_mode & S_IFMT) == S_IFDIR) /* a directory? */
    strcat(de_name, "/");
  nameLength = strlen(de_name);
  if (!CHECK_INSERT(nameLength))
    continue;
  f_name[filesMatched] = MALLOC(nameLength + 1);
  if (f_name[filesMatched] == NULL)
    goto ALL_DONE; /* Just forget the rest */

  strcpy(f_name[filesMatched], de_name);
  if (++filesMatched >= MAX_FILES_TO_SAVE)
    goto ALL_DONE;   /* JJD 3-89 forget about the rest of them */
  }

ALL_DONE:;
if (dir_pointer != NULL) {
  closedir(dir_pointer);
  dir_pointer = NULL;
  }
if (filesMatched > 0)
  ssort(f_name, filesMatched); /* JJD 3-89, alpha */
}

/* =======================================================================
 * Name - repeater
 *
 * Purpose - Dummy routine indicates repeat of completion command
 *
 * Arguments:
 *
 * Returns     function return --
 *
 * Note: This routine is never actually invoked.  It's a placemark for
 *       the character dispatch routine.
 *
 *========================================================================
 */
int repeater()
{
return OK;
}

/* =======================================================================
 * Name - glob
 *
 * Purpose - Pattern match
 *
 * Arguments:  pattern -- pattern to match against
 *             string -- text against which to match pattern
 *
 * Returns     function return --  TRUE if matched
 *
 *========================================================================
 */
/****************************************************************************
Following ONE ROUTINE is copyrighted separately:

----------------------------------------
Copyright (C) 1989 by Kenneth Almquist.
----------------------------------------

Following extracted from ash/LICENSE, as per request:

                   "ASH GENERAL PUBLIC LICENSE

  "1. You may copy and distribute ash code or code derived from it in
source or object form, provided that you conspicuously and appropriately
publish on each copy a valid copyright notice "Copyright 1989 by Kenneth
Almquist." (or with whatever year is appropriate); keep intact the
notices on all files that refer to this License Agreement and to the
absence of any warranty; and give any other recipients of the ash program
a copy of this License Agreement along with the program.

  "2. You may not copy, sublicense, distribute or transfer ash except as
expressly provided under this License Agreement.  Any attempt otherwise
to copy, sublicense, distribute or transfer ash is void and your rights
to use ash under this License agreement shall be automatically terminated.
However, parties who have received computer software programs from you
with this License Agreement will not have their licenses terminated so
long as such parties remain in full compliance.


                          "NO WARRANTY

  "Because ash is licensed free of charge, I provide absolutely no
warranty, to the extent permitted by applicable state law.  Except
when otherwise stated in writing, Kenneth Almquist and/or other
parties provide ash "as is" without warranty of any kind, either
expressed or implied, including, but not limited to, the implied
warranties of merchantability and fitness for a particular purpose.
The entire risk as to the quality and performance of the program is
with you.  Should the ash program prove defective, you assume the cost
of all necessary servicing, repair or correction.

 "In no event unless required by applicable law will Kenneth Almquist
and/or any other party who may modify and redistribute ash as permitted
above, be liable to you for damages, including any lost profits, lost
monies, or other special, incidental or consequential damages arising
out of the use or inability to use (including but not limited to loss
of data or data being rendered inaccurate or losses sustained by third
parties or a failure of the program to operate with programs provided
by other parties) the program, even if you have been advised of the
possibility of such damages, or for any claim by any other party."

Following routine is from pmatch in ash/expand.c:
*************************************************************************/

#define CTLESC '\\'

static BoolType glob(pattern, string)
      char pattern[];
      char string[];
{
register char *curPatPos, *curTextPos;
register char c;

curPatPos = &pattern[0];
curTextPos = &string[0];
for (;;) {
  switch (c = *curPatPos ++) {
  case '\0':
    goto breakloop;

  case CTLESC:
    if (*curTextPos ++ != *curPatPos ++)
      return FALSE;
    break;

  case '?':
    if (*curTextPos ++ == '\0')
      return FALSE;
    break;

  case '*':
    c = *curPatPos;
    if (c != CTLESC && c != '?' && c != '*' && c != '[') {
      while (*curTextPos != c) {
       if (*curTextPos == '\0')
         return FALSE;
       curTextPos ++;
       }
      }
    do {
      if (glob(curPatPos, curTextPos))
       return TRUE;
      } while (*curTextPos ++ != '\0');
    return FALSE;

  case '[': {
    char *endp;
    BoolType invert, found;
    char chr;

    endp = curPatPos;
    if (*endp == '!')
      endp ++;
    for (;;) {
      if (*endp == '\0')
       goto dft;               /* no matching ] */
      if (*endp == CTLESC)
       endp ++;
      if (* ++endp == ']')
       break;
      }
    invert = FALSE;
    if (*curPatPos == '!') {
      invert = TRUE;
      curPatPos ++;
      }
    found = FALSE;
    chr = *curTextPos ++;
    c = *curPatPos ++;
    do {
      if (c == CTLESC)
       c = *curPatPos ++;
      if (*curPatPos == '-' && curPatPos[1] != ']') {
       curPatPos ++;
       if (*curPatPos == CTLESC)
         curPatPos ++;
       if (chr >= c && chr <= *curPatPos)
         found = TRUE;
       curPatPos ++;
       }
      else {
       if (chr == c)
         found = TRUE;
       }
      } while ((c = *curPatPos ++) != ']');
    if (found == invert)
      return FALSE;
    break;
    }

dft:
  default:
    if (*curTextPos ++ != c)
      return FALSE;
    break;

    } /* end switch */
  }
breakloop:
if (*curTextPos != '\0')
  return FALSE;
return TRUE;
}

/* =======================================================================
 * Name - ssort
 *
 * Purpose - Shell Sort alla p.108 K&R C book
 *
 * Arguments:  v -- list of strings to sort
 *             n -- number of strings in v
 *
 * Returns     function return --
 *
 *========================================================================
 */
static int ssort (v, n)
char *v[];
int n;
{  /* JJD: Shell Sort alla p.108 K&R C book */
int gap, i, j;
char *temp;

for (gap = n / 2; gap > 0; gap /= 2)
  for (i = gap; i < n; i++)
    for (j = i - gap; j >= 0; j -= gap) {
      if (strcmp(v[j], v[j + gap]) <= 0)
        break;
      temp = v[j];
      v[j] = v[j + gap];
      v[j + gap] = temp;
      }
}
