#define CMDLINE_C TRUE
/*========================================================================
 *
 * Name - %M%
 *
 * Version:    %I%
 *
 * ccsid:      %W% - %G% %U%
 * from:       %F%
 * date:       %H% %T%
 *
 * %Q%
 *
 * Description: Implement simple semantics for command line args
 *              external interface -- get_command_line_arguments()
 *
 *========================================================================
 */
#include <sys/file.h>
#include <stdio.h>

#include "rkglobal.h"
#include "rk.h"
#include "defaults.h"
#include "kbdbind.h"
#include "getopt.h"
#include "display.h"
#include "system.h"
#include "utl.h"


static int print_help() /* rewritten by John April 1990 using show_arguments */
{
  set_default_files();
  get_termcap_stuff();
  set_up_keymap();
  get_key_bindings(key_file);  /* show user what they will get, not defaults */
  called_from_cmd_line = 1 /*TRUE*/ ;
  /* printf("RK Command Line Arguments and Default Values:\r\n"); */
  show_arguments();
}

static int print_version()
{
  called_from_cmd_line = 1 /*TRUE*/ ;
  show_version();
}


int get_command_line_arguments(argc,argv)
int argc;
char *argv[];
{
  int i;

  zero_freq_file = log_file = prime_file = key_file = NULL;
/* Could use to point RK at location on disk...
  ProgramName = argv[0];
... */

/* Command args are in order of appearance in show_arguments and
   show_system_toggles to make the interactive help (and the manual)
   easier to maintain.  There are four groups by arg type as follows:
				filename   numeric     boolean   toggle
		       group    |   1   |      2      |    3   |    4    | */
  while ((i = getopt(argc, argv,"k:p:q:z:b:e:f:i:m:n:o:cdlhsuv8AEILNOPRSW"))		    != EOF){
    switch( i ) {

/* 1. The command args that expect a filename. */
    case 'k':
      if( key_file != NULL) {
        fprintf(stderr, "%s: Too many -k options\n", argv[0]);
        abortit("", 1);
       }
      key_file = optarg;
      /* check for existance */
      if (access(key_file, R_OK) != 0){
        printf("%s: access() error on ", ProgramName);
        fflush(stdout);
        perror(key_file);
        abortit("", -1);
       }
       break;
    case 'p':
      if( prime_file != NULL ) {
       fprintf(stderr, "%s: Too many -p options\n", argv[0]);
       abortit("", 1);
       }
      prime_file = optarg;
      /* check for existance */
      if(access(prime_file, (R_OK|W_OK)) != 0){
        printf("%s: access() error on ", ProgramName);
       fflush(stdout);
        perror(prime_file);
       }
      break;
    case 'q':
      if( log_file != NULL ) {
       fprintf(stderr, "%s: Too many -l options\n", argv[0]);
       abortit("", 1);
       }
      log_file = optarg;
      /* check for existance */
      if(access(prime_file, (R_OK|W_OK)) != 0){
        printf("%s: access() error on ", ProgramName);
       fflush(stdout);
        perror(log_file);
       }
      break;
    case 'z':
      if (zero_freq_file != NULL)
        abortit("Too many -z options", 1);
      zero_freq_file = optarg;
      /* check for existence */
      if(access(zero_freq_file, (R_OK|W_OK)) != 0){
        printf("%s: access() error on ", ProgramName);
       fflush(stdout);
        perror(zero_freq_file);
        abortit("", -1);
       }
      break;

/* 2. The command args that take a numeric argument. */
    case 'b':
      num_buffers = atoi(optarg) + 1;
      if (num_buffers < 1)		          /* 1.. MAXINT*/
        abortit("-b: Buffers must be larger than 1.\n", -1);
      break;
    case 'e':
      max_eol = atoi(optarg);
      if (max_eol < 1) {
        fprintf(stderr, "-e: End of line length must be positive.\n");
        abortit("", -1);
        }
      break;
    case 'f':
      max_freq = atoi(optarg);
      if (max_freq < 3 || max_freq > MAX_FREQ) {
        fprintf(stderr, "-f: Maximum Frequency must be between 3 and %d.\n",
            MAX_FREQ);
        abortit("", -1);
        }
      break;
    case 'i':
      max_len = atoi(optarg);
      if (max_len < 1) {
        fprintf(stderr, "-i: Inline Length must be positive.\n");
        abortit("", -1);
        }
      break;
    case 'm':
      mem_limit = atoi(optarg);
      if (mem_limit <= 0) {
        fprintf(stderr, "-m: Memory maximum must be positive.\n");
        abortit("", -1);
        }
      break;
    case 'n':
      maxprime = atoi(optarg);
      break;
    case 'o':
      maxk = atoi(optarg);
      if (maxk < 3 || maxk > TOP_K){
        fprintf(stderr, "-o: Order must be between 3 and %d.\n", TOP_K);
        abortit("", -1);
       }
      break;

/* 3. The non-bindable command line booleans (all lowercase). */
    case 'c':
      cut_prime_mode = TRUE;
      break;
    case 'd':
      read_defaults_file();	/* Reads .rk.defaults written by setup */
      break;
    case 'l':
      login = !login;
      break;
    case 'h':
      print_help();
      abortit("", 0);
      break;
    case 's':
      silent = !silent;
      break;
    case 'u':
      underlineMode = !underlineMode;
      set_underline_mode();
      break;
    case 'v':
      print_version();
      abortit("", 0);
      break;
    case '8':
      eight_bit_mode = !eight_bit_mode;
      break;

/* 4. The command line boolean toggles that are key bindable (UPPERCASE). */
    case 'A':
      add_space_mode = !add_space_mode;
      break;
    case 'E':
      eol_longer_mode = !eol_longer_mode;
      break;
    case 'I':				/* called toggle_include_stuff */
      skip_nonword_mode = !skip_nonword_mode;
      break;
    case 'L':
      lisp_mode = !lisp_mode;
      break;
    case 'N':
      nl_truncate_mode = !nl_truncate_mode;
      break;
    case 'O':				/* called toggle_only_at_eof */
      eol_only_mode = !eol_only_mode;
      break;
    case 'P':
      pred_mode = !pred_mode;
      break;
    case 'R':   		        /* called toggle_record_all */
      log_all_mode = !log_all_mode;
      break;
    case 'S':
      show_eol_mode = !show_eol_mode;
      break;
    case 'W':
      wrap_mode = !wrap_mode;
      break;

    default:
      fprintf(stderr, "\r%s (%s): Use -h for help\r\n", argv[0], ProgramName);
      abortit("", -1);
    }

  }
 set_default_files();
if(!nl_truncate_mode && show_eol_mode) show_eol_mode = FALSE;
}

static set_default_files()  /* separated for use by print_help, John Apr 90 */
{
  static char z_freq_buf[MAXPATHLEN];
  static char prime_buf[MAXPATHLEN];
  static char log_buf[MAXPATHLEN];
  static char key_buf[MAXPATHLEN];
  char *homeEnv = getenv("HOME");

  if (homeEnv == NULL)
    homeEnv = "";
  if (zero_freq_file == NULL) {
    strcpy(z_freq_buf, homeEnv);
    strcat(z_freq_buf, ZERO_FREQ_FILE );
    zero_freq_file = z_freq_buf;
    }
  if (prime_file == NULL) {
    strcpy(prime_buf, homeEnv);
    strcat(prime_buf, PRIME_FILE );
    prime_file = prime_buf;
    }
  if (log_file == NULL) { /* default is prime file */
    strcpy(log_buf, prime_file);
    log_file = log_buf;
    }
  if (key_file == NULL) {
    strcpy(key_buf, homeEnv);
    strcat(key_buf, KEY_FILE );
    key_file = key_buf;
    }
}

/* need to do some rewriting, John */

read_defaults_file()   /* read file with defaults from SETUP, Dejan May 1990 */
{
	FILE * to, * fopen();
	char * getenv(), *pom, *kom, ppom[50];
	static char f[50], d[50], k[50];
	int lzff, llf, lpf;

	zero_freq_file= log_file= prime_file;

	pom=ppom;
	kom=getenv("HOME");
	strcpy(pom, kom);
	strcat(pom,"/.rk.defaults");
/*	printf("\n%s\n\n", pom);    SET FLAG TO REPORT IN MAIN AFTER GREET??*/
	to=fopen(pom,"r+");
	if(to== NULL) {
  printf("\nrk: unable to open .rk.defaults.  Have you run \"setup\" yet?\n");
		exit(0);
	}

	fscanf(to, "%d", & lzff);
	if(lzff > 0) {
		zero_freq_file=f;
		fscanf(to,"%s", zero_freq_file);
	}
	fscanf(to, "%d", & llf);
	if(llf > 0) {
		log_file=d;
		fscanf(to, "%s", log_file);
	}
	fscanf(to, "%d", & lpf);
	if(lpf > 0) {
		prime_file=k;
		fscanf(to, "%s", prime_file);
	}
	fscanf(to, 
		" %c %c %c %c %c %c %c %c %c %c %d%d%d%d%d%d%ld",
		& eol_longer_mode,
		& eol_only_mode,
		& lisp_mode,
		& login,
		& nl_truncate_mode,
		& pred_mode,
		& show_eol_mode,
		& silent,
		& underlineMode,
		& eight_bit_mode,
		& max_eol,
		& max_freq,
		& maxk,
		& max_len,
		& maxprime,
		& num_buffers,
		& mem_limit);
	fclose(to);
}
