#include "presto.h"
#include "set.h"


Set::Set()
{
	int i;

	for (i = 0; i < (MAXSIZE >> 5); i++)
		s_members[i] = 0;
	s_total = 0;
}

Set::~Set()
{}

Set*
Set::clone()
{
	Set *newset = new Set;
	int i;

	for (i = 0; i < (MAXSIZE >> 5); i++)
		newset->s_members[i] = s_members[i];
	newset->s_total = s_total;
	return(newset);
}

int
Set::ismember(int e)
{
	int i = e >> 5;
	int b = e & 0x1f;

	if (e >= MAXSIZE)
		return 0;
	if ((s_members[i] >> b) & 1)
		return 1;
	else
		return 0;
}

//
// Include and remove always assume that the argument is valid.
//

void
Set::include(int m)
{

	if (!ismember(m)) {
		s_total += m;
		s_members[m>>5] |= (1 << (m & 0x1f));
	}
}


void
Set::remove(int m)
{
	if (ismember(m)) {
		s_members[m>>5] &= ~(1 << (m & 0x1f));
		s_total -= m;
	}
}

void
Set::print(ostream &s)
{
	int i;

	for(i = 0; i < MAXSIZE; i++) {
		if (ismember(i))
			s << form("%d ", i);
	}
	s << "\n";
}
