//
// This program is intended to test proper operation of fork/join.
// Just do a bunch of fork/join sequences in parallel on the specified
// number of processors.
//

#include "presto.h"

#define MAXPROCS  32

int forks = 0;

void
err(char *s)
{
	cerr << s << "\n";
	exit(1);
}

Main::init()
{
	cout << "Initializing\n";
	cout.flush();
	numprocessors = 1;
	quantum = 0;

	for (argc--, argv++; *argv && **argv == '-'; argv++, argc--)
		switch (*(*argv + 1)) {
			case 'q':
				quantum = atoi(*argv + 2);
				break;
			case 'p':
				numprocessors = atoi(*argv + 2);
				break;
			case 'f':
				forks = atoi(*argv + 2);
				break;
			default:
				cerr << chr(*(*argv + 1)) << " unknown flag.\n";
		    		return -1;
		}
	return 0;
}

int
body(int zot)
{
//	int i;
//	for (i = 0; i < 50; i++);
	return zot;
}

void
forker(int forkcount)
{
	int forksdone;
	Thread *t;

	for(forksdone = 0; forksdone < forkcount; forksdone++) {
		t = new Thread();
		t->willjoin();
		t->start((Objany)0, (PFany)body, forksdone);
		if (t->join() != (Objany)forksdone)
			err("Bad join result");
	}
}


Main::main()
{
	int i;
	Thread *cpus[MAXPROCS];

	cout << "Here we go\n";
	cout.flush();

	for (i = 0; i < numprocessors; i++) {
		cpus[i] = new Thread();
		cpus[i]->willjoin();
		cpus[i]->start((Objany)0, (PFany)forker,
				(forks/numprocessors));
	}
	for (i = 0; i < numprocessors; i++) {
		cpus[i]->join();
	}
	cout << "...done.\n";
}

