
#include <stdio.h>
#include <stream.h>
#include "presto.h"

static shared_t int loopcount = 150;

int
Main::init()
{
	char *progname = argv[0];
	
	nummainthreads = 1;
	for (argc--, argv++; *argv && **argv == '-'; argv++, argc--)
		switch (*(*argv + 1)) {
			case 'q':
				quantum = atoi(*argv + 2);
				break;
			case 'n':
				numprocessors = atoi(*argv + 2);
				break;
			case 't':
				nummainthreads = atoi(*argv + 2);
				break;
			case 'l':
				loopcount = atoi(*argv + 2);
				break;
			default:
				cerr << chr(*(*argv + 1)) << " unknown flag.\n";
		    		return -1;
		}
	return 0;
}


static shared_t Spinlock spinner;
static shared_t int counter = 0;

int
Main::main()
{
	register int loopcnt = loopcount;
	register int ctr;
	Spinlock *sp = &spinner;

	while (loopcnt--)	{
		sp->lock();
		ctr = ++counter;
		if (ctr != counter)
			thisthread->error("Failure: occupied");
		sp->unlock();
	}
	return 0;
}

int
Main::done()
{
	printf("Success.\n");
	return 0;
}
