#include <stdio.h>
#include <stream.h>
#include "presto.h"

static shared_t int switchcount = 10;
static shared_t int verbose = 0;

int
Main::init()
{
	nummainthreads = 2;
	for (argc--, argv++; *argv && **argv == '-'; argv++, argc--)
		switch (*(*argv + 1)) {
			case 'q':
				quantum = atoi(*argv + 2);
				break;
			case 'n':
				numprocessors = atoi(*argv + 2);
				break;
			case 't':
				nummainthreads = atoi(*argv + 2);
				if (nummainthreads < 2)
					nummainthreads = 2;
				break;
			case 'v':
				verbose++;
				break;
			case 's':
				switchcount = atoi(*argv + 2);
				break;
			default:
				cerr << chr(*(*argv + 1)) << " unknown flag.\n";
		    		return -1;
		}
	switchcount = switchcount * nummainthreads;
	return 0;
}



static shared_t Monitor m("main_monitor");
static shared_t Condition c(m ,"condition");

#define SHOWME		{ if (verbose) {cout << thisproc->name() << ":" << \
				       thisthread->tid() << "," << mytid \
				       << ">" << switchcount << "\n"; }}

int
Main::main()
{

	register int  mytid = thisthread->tid();
	static shared_t int occupied = 0;

	{
	MONITOR ENTRY(m);
	if (!occupied)	{
		if (verbose)
			cout << "Not occupied " << thisthread->name() << "\n";
		occupied++;
		do	{
			c.wait();
			SHOWME;
			c.signal();
		} while (switchcount-- > 0);
		c.broadcast();
	} else	{
		if (verbose)
			cout << "occupied " << thisthread->name() << "\n";
		do 	{
			c.signal();
			c.wait();
			SHOWME;
		} while (switchcount-- > 0);
		c.broadcast();
	}
	if (verbose)
		cout << thisthread->name() << " Finished:" << switchcount << "\n";
	}	// exit monitor here
	return 0;
}

int
Main::done()
{
	printf("Success.\n", switchcount);
	return 0;
}
