#include <stdio.h>
#include <stream.h>
#include "presto.h"

static shared_t int loopcount = 150;

int
Main::init()
{
	char *progname = argv[0];
	
	nummainthreads = 1;
	for (argc--, argv++; *argv && **argv == '-'; argv++, argc--)
		switch (*(*argv + 1)) {
			case 'q':
				quantum = atoi(*argv + 2);
				break;
			case 'n':
				numprocessors = atoi(*argv + 2);
				break;
			case 't':
				nummainthreads = atoi(*argv + 2);
				break;
			case 'l':
				loopcount = atoi(*argv + 2);
				break;
			default:
				cerr << chr(*(*argv + 1)) << " unknown flag.\n";
		    		return -1;
		}
	return 0;
}

static shared_t Monitor m("main_monitor");
static shared_t int busy = 0;
	
void
monitored()
{
	int i;

	MONITOR ENTRY(&m);
	if (busy)	{
		cout << "Failure.\n";
		abort();
	}
	busy++;
	for (i = 0; i < 500; i++);
	loopcount--;
	busy--;
}

int
Main::main()
{
	while (loopcount > 0) {
		monitored();
	}
	return 0;
}

int
Main::done()
{
	cout << "Success.\n";
	return 0;
}
