
#include <stdio.h>
#include <stream.h>
#include "presto.h"


static shared_t int loopcount = 150;

int
Main::init()
{	
	nummainthreads = 1;
	for (argc--, argv++; *argv && **argv == '-'; argv++, argc--)
		switch (*(*argv + 1)) {
			case 'q':
				quantum = atoi(*argv + 2);
				break;
			case 'n':
				numprocessors = atoi(*argv + 2);
				break;
			case 't':
				nummainthreads = atoi(*argv + 2);
				break;
			case 'l':
				loopcount = atoi(*argv + 2);
				break;
			default:
				cerr << chr(*(*argv + 1)) << " unknown flag.\n";
		    		return -1;
		}
	return 0;
}



static shared_t Lock l("main_lock");
static shared_t int busy = 0;

int
Main::main()
{
	int i;
	while (loopcount > 0)	{
		l.lock();
		if (busy)	{
			cout << "Failure.\n";
			abort();
		}
		busy++;
		for (i = 0; i < 5000; i++);
		loopcount--;
		busy--;
		l.unlock();	
	}
	return 0;
}

int
Main::done()
{
	cout << "Success.\n";
	return 0;
}
