#include <stdio.h>
#include <stream.h>
#include "presto.h"

shared_t int verbose = 0;

int
Main::init()
{
	nummainthreads = 1;
	for (argc--, argv++; *argv && **argv == '-'; argv++, argc--)
		switch (*(*argv + 1)) {
			case 'q':
				quantum = atoi(*argv + 2);
				break;
			case 'n':
				numprocessors = atoi(*argv + 2);
				break;
			case 't':
				nummainthreads = atoi(*argv + 2);
				break;
			case 'v':
				verbose = 1;
				break;
			default:
				cerr << chr(*(*argv + 1)) << " unknown flag\n";
		    		return -1;
		}
	return 0;
}


static shared_t Monitor m("main_monitor");
static shared_t Condition c(&m, "condition");
static shared_t int awakened = 0;

int
Main::main()
{
	static shared_t int occupancy = 0;

	m.entry();
		occupancy++;
		if (occupancy == 1)
			if (verbose)
				printf("%s: thread ID %d started\n", 
				thisproc->name(), thisthread->tid());
		if (occupancy == nummainthreads) {
			if (verbose)
				printf("Occupant #%d broadcasting (%s.%d:%s)\n", 
				occupancy, thisproc->name(),
				thisthread->tid(), thisthread->name());

			awakened = 1;
			c.broadcast();
		} else	{
			if (verbose)
				printf("Occupant #%d sleeping (%s.%d:%s)\n", 
				occupancy, thisproc->name(),
				thisthread->tid(), thisthread->name());
			c.wait();	// release monitor
			if (!awakened) {
				printf("Failure.\n");
				abort();
			}
			if (verbose)
				printf("Occupant #%d waking (%s.%d:%s)\n", 
				occupancy, thisproc->name(),
				thisthread->tid(), thisthread->name());
		}
		occupancy--;
	m.exit();
}

int
Main::done()
{
	printf("Success.\n");
	return 0;
}
