
//
// Tests atomic integers.
//


#include <stream.h>
#include "presto.h"
#include "atomic_int.h"

AtomicInt counter = 0;
static shared_t loopcount = 150;

int
Main::init()
{
	nummainthreads = 1;
	for (argc--, argv++; *argv && **argv == '-'; argv++, argc--)
		switch (*(*argv + 1)) {
			case 'q':
				quantum = atoi(*argv + 2);
				break;
			case 'n':
				numprocessors = atoi(*argv + 2);
				break;
			case 't':
				nummainthreads = atoi(*argv + 2);
				break;
			case 'l':
				loopcount = atoi(*argv + 2);
				break;
			default:
				cerr << chr(*(*argv + 1)) << " unknown flag.\n";
		    		return -1;
		}
	return 0;
}
	
int
Main::main()
{
	int i;

	for(i = 0; i < loopcount; i++) {
//		counter += 2;
//		counter = counter - 2;
//		counter -= 2;
//		counter = counter + 2;
		counter++;
		counter--;
	}
}

int
Main::done()
{
	if (counter == 0)
		cout << "Success.\n";
	else
		cout << form("Failure: counter is %d.\n", counter);
	return 0;
}




