//
// An extremely simple Presto thread exerciser.  T threads
// run on N processors with preemption quantum Q milliseconds.
// Each thread spins for S iterations in a tight loop, prints
// an identifying string, and exits.
//
// Jeff Chase 8/15/88
//

#include "presto.h"
#include "burner.h"

//
// These are runtime parameters set from command-line arguments.
// Also: numprocessors, quantum
//
int burnercount = 5;
int spins = 500000;

burner::burner(int ident, int stop)
{
	spincount = 0;
	stopcount = stop;
	id = ident;
}

burner::~burner()
{
}

void
burner::run()
{
	bthread = new Thread("burner");
	bthread->willjoin();
	bthread->start(this, (PFany)(this->spin));
}

void
burner::spin()
{
	int i;

	while(spincount <= stopcount) {
		for (i = 0; i < 1000; i++) spincount++;
	} 
	//
	// There should probably be some protection on the couts.
	//
	cout << form("(%d)", id);
	cout.flush();
}

int
burner::join()
{
	return((int)(bthread->join()));
}

Main::init()
{
	numprocessors = 1;
	quantum = 0;

	for (argc--, argv++; *argv && **argv == '-'; argv++, argc--)
		switch (*(*argv + 1)) {
			case 'q':
				quantum = atoi(*argv + 2);
				break;
			case 'n':
				numprocessors = atoi(*argv + 2);
				break;
			case 's':
				spins = atoi(*argv + 2);
				break;
			case 't':
				burnercount = atoi(*argv + 2);
				break;
			default:
				cerr << chr(*(*argv + 1)) << " unknown flag.\n";
		    		return -1;
		}
	return 0;
}

Main::main()
{

	Oqueue burnerq;
	burner *b;
	int i;

	for(i = 0; i < burnercount; i++) {
		b = new burner(i, spins);
		burnerq.append(b);
		b->run();
	}

	while((b = (burner *)burnerq.get()) != NULL)
		b->join();

	cout << "...done.\n";
}
