#include "presto.h"

#include "barrier.h"

// #define debugprint

MasterSlaveBarrier::MasterSlaveBarrier (int numslaves)
{
#ifdef debugprint
  cout << "MasterSlaveBarrier: numslaves = " << numslaves << "\n";
#endif
  b_monitor = new Monitor ("MonitorMasterSlaveBarrier");
  master_goahead = new Condition (b_monitor,"MasterSlaveBarrierCondition");
  nslaves = numslaves;
  arrivals = 0;
  current_lock = 0;
  l[0] = new Lock ("#0MasterSlaveBarrierLock");
  l[1] = new Lock ("#1MasterSlaveBarrierLock");
  l[0]->lock ();
}

void
MasterSlaveBarrier::SlaveArrive ()
{
  Lock *barrier;
#ifdef debugprint
  cout << "SlaveArrive at " << (int) this 
       << ": current_lock = " << current_lock << "\n";
#endif
  {
    MONITOR ENTRY(b_monitor);
    arrivals++;
    if (arrivals == nslaves+1) {  /* all slaves plus master have arrived */
#ifdef debugprint
    cout << "SlaveArrive at " << (int) this 
         << ": signaling master via " << (int) master_goahead << "\n";
#endif
      master_goahead->signal();   /* let master continue (when we're done */
#ifdef debugprint
    cout << "SlaveArrive at " << (int) this 
         << ": done signaling master \n";
#endif
    }
    barrier = l[current_lock];    /* remember which lock we're all using */
  }
#ifdef debugprint
  cout << "SlaveArrive at " << (int) this 
       << ": locking barrier " << (int) barrier << "\n";
#endif
  barrier->lock();     /* and queue up waiting for everybody to arrive */
#ifdef debugprint
  cout << "SlaveArrive at " << (int) this 
       << ": unlocking barrier " << (int) barrier << "\n";
#endif
  barrier->unlock();   /* then one by one release the whole bunck */
#ifdef debugprint
  cout << "SlaveArrive at " << (int) this 
       << ": unlocked barrier " << (int) barrier << "\n";
#endif
}

void
MasterSlaveBarrier::MasterArrive ()
{
  MONITOR ENTRY(b_monitor);
#ifdef debugprint
  cout << "MasterArrive: current_lock = " << current_lock << "\n";
#endif
  arrivals++;
  if (arrivals < nslaves+1) {  /* not all slaves have arrived yet */
#ifdef debugprint
    cout << "MasterArrive at " << (int) this << " Waiting\n" ;
#endif
    master_goahead->wait();    /* so wait for them */
                               /* (implicitly exiting b_monitor) */
  }
}

void
MasterSlaveBarrier::LetSlavesGo ()
  // entered only with all slaves blocked in SlaveArrive
{
  MONITOR ENTRY(b_monitor);
#ifdef debugprint
  cout << "LetSlavesGo at " << (int) this
       << ": current_lock = " << current_lock << "\n";
#endif
  arrivals = 0;
  current_lock = 1 - current_lock;   // switch locks for next barrier
#ifdef debugprint
  cout << "LetSlavesGo at " << (int) this
       << " locking " << (int) l[current_lock] << "\n";
#endif
  l[current_lock]->lock ();          // make 'em stop at next barrier
#ifdef debugprint
  cout << "LetSlavesGo at " << (int) this
       << " unlocking " << (int) l[1-current_lock] << "\n";
#endif
  l[1-current_lock]->unlock ();      // and let 'em go!
#ifdef debugprint
  cout << "LetSlavesGo at " << (int) this 
       << ": unlocked " << (int) l[1-current_lock] << "\n";
#endif
}

