/*
 * Spinlock support for the Firefly.
 */

	.file	"vax_lock.s"
.text
	.data
	.text

/*
 * s_lock - lock a spinlock.
 *
 * The lock function is a little contorted...the delay state
 * prevents us from locking up the Mbus with an interlocked spin.
 * Maybe should use a row of nops here to avoid trashing r0.
 */

	.align	2
	.globl	_s_lock

_s_lock:
	.word 0x1
test:
	bbssi	$0, *4(ap), fail
	ret
fail:
	clrl	r0
delay:
	cmpl	r0,$3
	jgeq	test
	incl	r0
	jbr 	delay

/*
 * s_unlock
 */

	.align	2
	.globl	_s_unlock
_s_unlock:
	.word 0x0
	bbcci	$0, *4(ap), next
next:
	ret


/*
 * s_clock - attempt to acquire, but do not spin.
 */

	.align	2
	.globl	_s_clock
_s_clock:
	.word 0x0
	bbssi	$0, *4(ap), lost
	movl	$1, r0
	ret
lost:
	movl	$0, r0
	ret

