
/*
 * Unix support for timer object.
 *
 */
#include "presto.h"

void
Timer::init()
{
	t_starttime = getabsolutetime();
}

Timer::~Timer()
{
}


double
Timer::getabsolutetime()
{
	struct timeval *t_tv;
	t_tv = gettimeofday();
	return (double)t_tv->tv_sec +
		((double)(t_tv->tv_usec) * 1.0e-6);
}

char*
Timer::getasciitime()
{
	struct timeval *t_tv;
	t_tv = gettimeofday();
	return ctime((long*)&t_tv->tv_sec);
}




struct timeval* 
Timer::gettimeofday()
{
	::gettimeofday(&t_time,0);
	return &t_time;
}

void
Timer::print(ostream& s)
{
	s << form("(Timer)this= 0x%x,", this) << 
	     "t_starttime = " << t_starttime;
}
