//
//
//	Processes work as hungry puppies, banging on the scheduler
//	until a ready job is available or until someone bangs on the
//	process asking it to do something "out of band" (like pausing
//	or dying).
//

extern Process *sysproc;

class Invocation;

#define NUMPROCS	16

class Process	: public Object 	{
#if (sun && THREAD_HAS_INTERRUPTIBLE_FIELD)
	int	p_interruptible;
#endif
#ifdef vax
	// WARNING: The offset of p_interruptible is known to swtch().
	int	p_interruptible;
#endif vax
	char	*p_name;			// my name
	int	p_id;				// my id
	int	p_pid;				// system pid
	int	p_ppid;				// system ppid
protected:
	int	p_state;			// whats up
	int 	p_flags;			// long term process stuff
	int	p_request;			// stop spinning on this
	Thread  *p_schedthread;			// where to swtch back to 
	Thread	*p_thread;			// currently running thread
#define NEWPROCESS
	virtual void	p_fork();			// take care of the fork
	virtual void	p_wait();			// where we spin
	virtual void	p_pause();			// internal ::pause
	virtual void	p_runchild(int *spinflag);	// copy stack and go
public:
	Process(int ptag, int id);
	Process();
	Process(char* name, int id, int delayedfork = 0); // fork in ctor
	virtual ~Process();
	// virtual newprocess function.  After creation of the first thisproc,
	// raw process constructor is not used.  thisproc->newprocess() is
	// used instead.  User can assign his own derivation of Process to
	// thisproc in Main::init().
	virtual Process* newprocess(char* name,int id);	
	virtual int	request(int req);
	virtual void	park();			// os pause
	virtual void	drive();		// resume
	virtual int	invoke();
	int	state()
		{ return p_state; }
	void 	setstate(int st)
		{ p_state = st; }
	int 	flags()
		{ return p_flags; }
	inline int isroot();
	int	id()				// scheduler id
		{return p_id; }	
	int	pid()			// unix id
		{ return p_pid; }
	int 	ppid()			// unix parent id
		{ return p_ppid; }
	char *	name()
		{ return p_name; }
	Thread	*schedthread()
		{ return p_schedthread; }
	Thread	*runningthread()
		{ return p_thread; }
#if (sun && THREAD_HAS_INTERRUPTIBLE_FIELD)
	int	interruptible()
		{ return p_interruptible; }
	inline int disable_interrupts();
	void enable_interrupts()
		{ p_interruptible = 1; }
#endif sun
#ifdef vax
	int	interruptible()
		{ return p_interruptible; }
	inline int disable_interrupts();
	void enable_interrupts()
		{ p_interruptible = 1; }
#endif vax
	virtual void print(ostream& = cout);
	virtual void	error(char *s);
};

	
#define R_NULL		0x00	/* nothing is happening */
#define R_WAKEUP	0x01	/* wakeup wherever you are */
#define R_PARK		0x02	/* put yourself to sleep in the OS */
#define R_DIE		0x04	/* the nice way to kill a process */
#define R_RETURN	0x08	/* relinquish control */
/*
 * We don't need R_DIE and R_RETURN since the process wait routine
 * only understands how to R_RETURN from its scheduling loop.  Where
 * it returns to is completely determined by how it was invoked.
 * If it was invoked from runchild, then we will return to there
 * and get nuked with a (delete this).  If we were called via runrun
 * from the Main constructor, then we will return to single threaded
 * control.
 */

#define S_RUN		0x01	/* running */
#define S_WAIT		0x02	/* unused.  waiting to be used in spinloop */
#define S_SLEEP		0x04	/* sleeping on an event */
#define S_OSPAUSE	0x08	/* WAITing or SLEEPing via OS pause */
#define S_FREE		(S_WAIT|S_OSPAUSE)
#define S_ZOMBIE	0x10
#define S_EXITING	0x20
#define S_DELAYEDFORK	0x40	/* constructed, but not yet forked */
#define S_FORKING	0x80	/* as we speak... */
#define S_ERROR		0x100
#define S_REAPED	0x200	/* already cleaned up */
#define S_REAPING	0x400	/* parent process cleaning up */


//
// special proc tags for flags field
//
#define P_ROOT		0x01

inline int Process::isroot()
{
	return (p_flags&P_ROOT);
}

#if (sun && THREAD_HAS_INTERRUPTIBLE_FIELD)
inline int Process::disable_interrupts()
{
	if (p_interruptible)	{
		p_interruptible = 0;
		return 1;

	} else
		return 0;
}
#endif sun
#ifdef vax
inline int Process::disable_interrupts()
{
	if (p_interruptible)	{
		p_interruptible = 0;
		return 1;

	} else
		return 0;
}
#endif vax

extern private_t Process	*thisproc;	// private to each proc
