/*
 * Generic clock interface
 */


#ifndef ITIMER_REAL
#include <sys/time.h>
#endif

extern int gettimeofday(struct timeval*, struct timezone*);

class Timer : public Object	{
	double t_starttime;
	struct timeval t_time;
public:

	Timer()
		{;}				// satisfy compiler
	void init();				// intentional ctor only
	~Timer();
	struct timeval* gettimeofday();
	double getabsolutetime();
	char *getasciitime();
	void  timerstart()
		{ t_starttime = getabsolutetime(); }
	void reinit()
		{ timerstart(); }
	double timermark()
		{ return getabsolutetime() - t_starttime; }
	virtual void print(ostream& = cout);
};


