
//
// Thread Q stuff
//


//
// ThreadQUnlocked should be used when the threadq is already 
// associated with a locked data structuire (such as a synchronization
// object).  We save having to test for locking.
//

class ThreadQUnlocked	: public Oqueue	{
	int	tq_neededstate;
public:
	ThreadQUnlocked(int neededstate, Thread *t = 0);
	~ThreadQUnlocked();
	inline Thread* get();
	inline Thread* 	lookat();
	inline void    	append(Thread* t);
	inline void	prepend(Thread* t);
	inline void 	remove(Thread* t);
	virtual void print(ostream& = cout);
};

class ThreadQ	: public Oqueue	{
	int		tq_neededstate;		// sanity check
	int		tq_length;
	Spinlock 	*tq_lock;
	inline		void lock();
	inline		void unlock();
public:
	ThreadQ(int neededstate, Thread *t = 0);
	~ThreadQ();
	inline Thread*	get();
	inline Thread* 	lookat();
	inline void    	append(Thread* t);
	inline void	prepend(Thread* t);
	inline void 	remove(Thread* t);
	int		length()
				{ return tq_length; }
	virtual void print(ostream& = cout);
};



inline
Thread*
ThreadQUnlocked::get()
{  
	Thread* t = (Thread*)(Oqueue::get());
	if (t==0 || t->t_state&tq_neededstate) 
		return t;
	else
	   	t->error("get bad state");
}

inline
Thread*
ThreadQUnlocked::lookat()
{
	Thread* t = (Thread*)(Oqueue::lookat());
	if (t==0 || t->t_state&tq_neededstate)
	   	return t;
	else
	   	t->error("get bad state");
}


inline
void
ThreadQUnlocked::append(Thread* t)
{
	if (t==0 || t->t_state&tq_neededstate)	{
		Oqueue::append(t); 
	} else
		t->error("Bad state append");
}



inline
void
ThreadQUnlocked::prepend(Thread* t)
{
	if (t==0 || t->t_state&tq_neededstate)	{
		Oqueue::prepend(t); 
	}  else
	  	t->error("Bad state prepend");
}


inline
void
ThreadQUnlocked::remove(Thread *t)
{ 
	if (t==0 || t->t_state&tq_neededstate)	{
		Oqueue::remove(t); 
	} else
	  	t->error("Bad state remoeve");
}


//
// Locked threadq's
//
inline
void ThreadQ::lock()
{
	register Spinlock *sp = tq_lock; 
	sp->lock(); 
}

inline
void ThreadQ::unlock()
{
	register Spinlock *sp = tq_lock; 
	sp->unlock(); 
}



inline
Thread*
ThreadQ::get()
{  
	lock();
	Thread* t = (Thread*)(Oqueue::get());
	if (t)
		tq_length--;
	unlock();
	
	if (t==0 || t->t_state&tq_neededstate) 
		return t;
	else
	   	t->error("get bad state");
}
			
inline
Thread*
ThreadQ::lookat()
{
	Thread* t = (Thread*)(Oqueue::lookat());
	if (t==0 || t->t_state&tq_neededstate)
	   	return t;
	else
	   	t->error("get bad state");
}
	

inline
void
ThreadQ::append(Thread* t)
{
	if (t && t->t_state&tq_neededstate)	{
		lock();
		Oqueue::append(t); 
		tq_length++;
		unlock();
	} else
		t->error("Bad state append");
}



inline
void
ThreadQ::prepend(Thread* t)
{
	if (t && t->t_state&tq_neededstate)	{
		lock();
		Oqueue::prepend(t);
		tq_length++; 
		unlock();
	}  else
	  	t->error("Bad state prepend");
}

inline
void
ThreadQ::remove(Thread *t)
{ 
	if (t && t->t_state&tq_neededstate)	{
		lock();
		Oqueue::remove(t); 
		tq_length--;
		unlock();
	} else
	  	t->error("Bad state remoeve");
}






