//
// Synchronization objects.
//


class SynchroObject : public Object {
	Spinlock	*so_lock;
	ThreadQUnlocked	*so_waiting;
public:
	SynchroObject(int t, char *name=0);
	~SynchroObject();
	inline void remember(Thread* t);
	inline Thread* recall();
	inline void lock();			// always inline
	inline void unlock();			// cyclic dependencies!
	inline ThreadQUnlocked	*waitingQueue();
	virtual void print(ostream& = cout);
};

inline void
SynchroObject::lock()
{	
	register Spinlock *sp = so_lock;
 	sp->lock();
}

inline void
SynchroObject::unlock()
{
	register Spinlock *sp = so_lock;
	sp->unlock();
}



inline
Thread*
SynchroObject::recall()
{
	register ThreadQUnlocked *soq = so_waiting;
	return soq->get();
}

inline
void
SynchroObject::remember(Thread *t)
{
	register ThreadQUnlocked *soq = so_waiting;
	t->orstate(TS_BLOCKED);
	//
	// at this point, we are both blocked AND running.  We have been
	// blocked as far as the queue is concerned, but we still need
	// to sleep ourselves before we can be considered not running
	//
	soq->append(t);
}

inline
ThreadQUnlocked*
SynchroObject::waitingQueue()
{
	return so_waiting;
}


